/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.netty.codec;

import com.robothy.netty.http.HttpRequest;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.ReferenceCountUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class HttpRequestDecoder
extends MessageToMessageDecoder<HttpObject> {
    private HttpRequest.HttpRequestBuilder builder;
    private CompositeByteBuf body;

    protected void decode(ChannelHandlerContext ctx, HttpObject msg, List<Object> out) throws Exception {
        if (msg instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)msg;
            HashMap<CharSequence, String> headers = new HashMap<CharSequence, String>();
            httpRequest.headers().forEach(header -> headers.put(((String)header.getKey()).toLowerCase(Locale.ROOT), (String)header.getValue()));
            this.body = Unpooled.compositeBuffer();
            QueryStringDecoder queryStringDecoder = new QueryStringDecoder(httpRequest.uri());
            this.builder = com.robothy.netty.http.HttpRequest.builder().method(httpRequest.method()).uri(httpRequest.uri()).httpVersion(httpRequest.protocolVersion()).headers(headers).body((ByteBuf)this.body).path(queryStringDecoder.path()).params(new HashMap<CharSequence, List<String>>(queryStringDecoder.parameters()));
            String expect = httpRequest.headers().getAsString((CharSequence)HttpHeaderNames.EXPECT);
            if (HttpHeaderValues.CONTINUE.contentEqualsIgnoreCase((CharSequence)expect)) {
                ctx.writeAndFlush((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
            }
        } else if (msg instanceof HttpContent) {
            HttpContent httpContent = (HttpContent)msg;
            ByteBuf content = httpContent.content();
            ReferenceCountUtil.retain((Object)content);
            this.body.addComponent(true, content);
            if (msg instanceof LastHttpContent) {
                com.robothy.netty.http.HttpRequest request = this.builder.build();
                out.add(request);
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        cause.printStackTrace();
        ctx.close();
    }
}

