/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.netty.router;

import com.robothy.netty.http.HttpRequest;
import com.robothy.netty.http.HttpRequestHandler;
import com.robothy.netty.router.ExceptionHandler;
import com.robothy.netty.router.Route;
import com.robothy.netty.router.SpringWebRouter;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;

public interface Router {
    public static final HttpRequestHandler DEFAULT_NOT_FOUND_HANDLER = (request, response) -> response.status(HttpResponseStatus.NOT_FOUND).write("Netty HTTP Router: 404 Not Found.");

    public static Router router() {
        return new SpringWebRouter();
    }

    public Router route(Route var1);

    default public Router route(HttpMethod method, String path, HttpRequestHandler handler) {
        Route rule = Route.builder().method(method).path(path).handler(handler).build();
        return this.route(rule);
    }

    public Router notFound(HttpRequestHandler var1);

    public Router staticResource(String var1);

    public <T extends Throwable> Router exceptionHandler(Class<T> var1, ExceptionHandler<T> var2);

    public ExceptionHandler<Throwable> findExceptionHandler(Class<? extends Throwable> var1);

    public HttpRequestHandler match(HttpRequest var1);
}

