/*
 * Decompiled with CFR 0.152.
 */
package com.robothy.netty.router;

import com.robothy.netty.http.HttpRequest;
import com.robothy.netty.http.HttpRequestHandler;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Objects;

abstract class StaticResourceMatcher {
    StaticResourceMatcher() {
    }

    abstract HttpRequestHandler match(HttpRequest var1);

    static StaticResourceMatcher create(String path) {
        Objects.requireNonNull(path, "The static resource path shouldn't be null.");
        if (path.startsWith("classpath:")) {
            return new ClasspathResourceMatcher(path);
        }
        return new DirectoryResourceMatcher(path);
    }

    private static class ClasspathResourceMatcher
    extends StaticResourceMatcher {
        private final String resourceRoot;
        private final HttpRequestHandler handler;

        ClasspathResourceMatcher(String path) {
            this.resourceRoot = path.substring("classpath:".length());
            this.handler = (request, response) -> {
                String resourceName = this.resourceName(request);
                URL url = Thread.currentThread().getContextClassLoader().getResource(resourceName);
                Objects.requireNonNull(url, request.getPath() + " not exist.");
                String urlStr = url.toString();
                String contentType = Files.probeContentType(Paths.get(urlStr.substring(urlStr.lastIndexOf("/") + 1), new String[0]));
                response.putHeader(HttpHeaderNames.CONTENT_TYPE.toString(), contentType);
                try (InputStream in = url.openStream();){
                    response.write(in.readAllBytes());
                }
            };
        }

        @Override
        public HttpRequestHandler match(HttpRequest request) {
            String resourceName = this.resourceName(request);
            URL resource = Thread.currentThread().getContextClassLoader().getResource(resourceName);
            if (null == resource) {
                return null;
            }
            return this.handler;
        }

        String resourceName(HttpRequest request) {
            if ("/".equals(request.getPath()) || "".equals(request.getPath())) {
                return this.resourceRoot + "/index.html";
            }
            return this.resourceRoot + request.getPath();
        }
    }

    private static class DirectoryResourceMatcher
    extends StaticResourceMatcher {
        private static final int MAP_THRESHOLD = 0xA00000;
        private final HttpRequestHandler handler;
        private final String rootDirectory;

        DirectoryResourceMatcher(String directory) {
            this.rootDirectory = directory;
            this.handler = (request, response) -> {
                String filename = this.filename(request);
                Path absPath = Paths.get(directory, filename);
                try (FileChannel fileChannel = FileChannel.open(absPath, StandardOpenOption.READ);){
                    long contentLength = fileChannel.size();
                    response.status(HttpResponseStatus.OK).putHeader(HttpHeaderNames.CONTENT_LENGTH.toString(), contentLength).putHeader(HttpHeaderNames.CONTENT_TYPE.toString(), Files.probeContentType(absPath));
                    if (contentLength > 0xA00000L) {
                        MappedByteBuffer byteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, contentLength);
                        response.write(Unpooled.wrappedBuffer((ByteBuffer)byteBuffer));
                    } else {
                        int size = (int)contentLength;
                        ByteBuffer buf = ByteBuffer.allocate(size);
                        int readLen = 0;
                        while (size != (readLen += fileChannel.read(buf, readLen))) {
                            buf.compact();
                        }
                        buf.flip();
                        response.write(Unpooled.wrappedBuffer((ByteBuffer)buf));
                    }
                }
            };
        }

        @Override
        public HttpRequestHandler match(HttpRequest request) {
            if (request.getMethod() != HttpMethod.GET) {
                return null;
            }
            String filename = this.filename(request);
            Path absPath = Paths.get(this.rootDirectory, filename);
            if (!absPath.toFile().exists()) {
                return null;
            }
            return this.handler;
        }

        private String filename(HttpRequest request) {
            if ("".equals(request.getPath()) || "/".equals(request.getPath())) {
                return "index.html";
            }
            return Paths.get(request.getPath(), new String[0]).normalize().toString();
        }
    }
}

