/*
 * Decompiled with CFR 0.152.
 */
package jadx.api.plugins.input.data.annotations;

import jadx.api.plugins.input.data.annotations.EncodedType;
import jadx.api.plugins.input.data.attributes.IJadxAttrType;
import jadx.api.plugins.input.data.attributes.IJadxAttribute;
import jadx.api.plugins.input.data.attributes.JadxAttrType;
import jadx.api.plugins.input.data.attributes.PinnedAttribute;
import java.util.Objects;

public class EncodedValue
extends PinnedAttribute {
    public static final EncodedValue NULL = new EncodedValue(EncodedType.ENCODED_NULL, null);
    private final EncodedType type;
    private final Object value;

    public EncodedValue(EncodedType type, Object value) {
        this.type = type;
        this.value = value;
    }

    public EncodedType getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EncodedValue that = (EncodedValue)o;
        return this.type == that.getType() && Objects.equals(this.value, that.getValue());
    }

    @Override
    public IJadxAttrType<? extends IJadxAttribute> getAttrType() {
        return JadxAttrType.CONSTANT_VALUE;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getType(), this.getValue()});
    }

    public String toString() {
        switch (this.type) {
            case ENCODED_NULL: {
                return "null";
            }
            case ENCODED_STRING: {
                return (String)this.value;
            }
            case ENCODED_ARRAY: {
                return "[" + this.value + "]";
            }
        }
        return "{" + (Object)((Object)this.type) + ": " + this.value + '}';
    }
}

