/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.asyncapi.v3.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import io.github.springwolf.asyncapi.v3.jackson.AsyncApiSerializerService;
import io.swagger.v3.core.util.ObjectMapperFactory;

public class DefaultAsyncApiSerializerService
implements AsyncApiSerializerService {
    private final ObjectMapper jsonMapper = ObjectMapperFactory.createJson31();
    private final ObjectMapper yamlMapper = ObjectMapperFactory.createYaml31();
    private final PrettyPrinter printer = new CustomPrettyPrinter();

    public DefaultAsyncApiSerializerService() {
        this.jsonMapper.enable(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS);
        this.yamlMapper.enable(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS);
        ((YAMLFactory)this.yamlMapper.getFactory()).enable(YAMLGenerator.Feature.INDENT_ARRAYS_WITH_INDICATOR);
    }

    @Override
    public String toJsonString(Object object) throws JsonProcessingException {
        return this.jsonMapper.writer(this.printer).writeValueAsString(object);
    }

    @Override
    public String toYaml(Object object) throws JsonProcessingException {
        return this.yamlMapper.writer(this.printer).writeValueAsString(object);
    }

    public ObjectMapper getJsonObjectMapper() {
        return this.jsonMapper;
    }

    public ObjectMapper getYamlObjectMapper() {
        return this.yamlMapper;
    }

    private static class CustomPrettyPrinter
    extends DefaultPrettyPrinter {
        public CustomPrettyPrinter() {
            this._arrayIndenter = new DefaultIndenter();
            this._objectFieldValueSeparatorWithSpaces = this._separators.getObjectFieldValueSeparator() + " ";
        }

        public CustomPrettyPrinter createInstance() {
            return new CustomPrettyPrinter();
        }
    }
}

