/*
 * Decompiled with CFR 0.152.
 */
package io.github.toolfactory.jvm;

import io.github.toolfactory.jvm.Driver;
import io.github.toolfactory.jvm.function.catalog.AllocateInstanceFunction;
import io.github.toolfactory.jvm.function.catalog.BuiltinClassLoaderClassSupplier;
import io.github.toolfactory.jvm.function.catalog.ClassLoaderDelegateClassSupplier;
import io.github.toolfactory.jvm.function.catalog.ConstructorInvokeMethodHandleSupplier;
import io.github.toolfactory.jvm.function.catalog.ConsulterSupplyFunction;
import io.github.toolfactory.jvm.function.catalog.DeepConsulterSupplyFunction;
import io.github.toolfactory.jvm.function.catalog.DefineHookClassFunction;
import io.github.toolfactory.jvm.function.catalog.GetDeclaredConstructorsMethodHandleSupplier;
import io.github.toolfactory.jvm.function.catalog.GetDeclaredFieldsMethodHandleSupplier;
import io.github.toolfactory.jvm.function.catalog.GetDeclaredMethodsMethodHandleSupplier;
import io.github.toolfactory.jvm.function.catalog.GetFieldValueFunction;
import io.github.toolfactory.jvm.function.catalog.GetLoadedClassesFunction;
import io.github.toolfactory.jvm.function.catalog.GetLoadedPackagesFunction;
import io.github.toolfactory.jvm.function.catalog.GetPackageFunction;
import io.github.toolfactory.jvm.function.catalog.MethodInvokeMethodHandleSupplier;
import io.github.toolfactory.jvm.function.catalog.SetAccessibleFunction;
import io.github.toolfactory.jvm.function.catalog.SetFieldValueFunction;
import io.github.toolfactory.jvm.function.catalog.ThrowExceptionFunction;
import io.github.toolfactory.jvm.function.template.BiFunction;
import io.github.toolfactory.jvm.function.template.Function;
import io.github.toolfactory.jvm.function.template.TriConsumer;
import io.github.toolfactory.jvm.util.BiConsumerAdapter;
import io.github.toolfactory.jvm.util.FunctionAdapter;
import io.github.toolfactory.jvm.util.ObjectProvider;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class DefaultDriver
implements Driver {
    ThrowExceptionFunction exceptionThrower;
    Function<Class<?>, Object> allocateInstanceInvoker;
    BiFunction<Object, Field, Object> fieldValueRetriever;
    TriConsumer<Object, Field, Object> fieldValueSetter;
    BiFunction<Class<?>, byte[], Class<?>> hookClassDefiner;
    FunctionAdapter<?, Class<?>, MethodHandles.Lookup> consulterRetriever;
    MethodHandle declaredFieldsRetriever;
    MethodHandle declaredMethodsRetriever;
    MethodHandle declaredConstructorsRetriever;
    BiConsumerAdapter<?, AccessibleObject, Boolean> accessibleSetter;
    MethodHandle constructorInvoker;
    BiFunction<ClassLoader, String, Package> packageRetriever;
    MethodHandle methodInvoker;
    Class<?> builtinClassLoaderClass;
    Class<?> classLoaderDelegateClass;
    Function<ClassLoader, Collection<Class<?>>> loadedClassesRetriever;
    Function<ClassLoader, Map<String, ?>> loadedPackagesRetriever;

    public DefaultDriver() {
        ObjectProvider functionProvider = new ObjectProvider("ForJava", 7, 9, 14, 17);
        HashMap<Object, Object> initializationContext = new HashMap<Object, Object>();
        this.initExceptionThrower(functionProvider, initializationContext);
        try {
            this.initAllocateInstanceInvoker(functionProvider, initializationContext);
            this.initFieldValueRetriever(functionProvider, initializationContext);
            this.initFieldValueSetter(functionProvider, initializationContext);
            this.initHookClassDefiner(functionProvider, initializationContext);
            this.initConsulterRetriever(functionProvider, initializationContext);
            this.initDeclaredFieldsRetriever(functionProvider, initializationContext);
            this.initDeclaredMethodsRetriever(functionProvider, initializationContext);
            this.initDeclaredConstructorsRetriever(functionProvider, initializationContext);
            this.initAccessibleSetter(functionProvider, initializationContext);
            this.initConstructorInvoker(functionProvider, initializationContext);
            this.initMethodInvoker(functionProvider, initializationContext);
            this.initPackageRetriever(functionProvider, initializationContext);
            this.initBuiltinClassLoaderClass(functionProvider, initializationContext);
            this.initClassLoaderDelegateClass(functionProvider, initializationContext);
            this.replaceConsulterWithDeepConsulter(functionProvider, initializationContext);
            this.initLoadedClassesRetriever(functionProvider, initializationContext);
            this.initLoadedPackagesRetriever(functionProvider, initializationContext);
        }
        catch (Throwable exc) {
            this.throwException(new Driver.InitializeException("Could not initiliaze " + this.getClass().getSimpleName(), exc), new Object[0]);
        }
    }

    void initExceptionThrower(ObjectProvider functionProvider, Map<Object, Object> initializationContext) {
        this.exceptionThrower = functionProvider.getOrBuildObject(ThrowExceptionFunction.class, initializationContext);
    }

    void initLoadedPackagesRetriever(ObjectProvider functionProvider, Map<Object, Object> initializationContext) {
        this.loadedPackagesRetriever = functionProvider.getOrBuildObject(GetLoadedPackagesFunction.class, initializationContext);
    }

    void initLoadedClassesRetriever(ObjectProvider functionProvider, Map<Object, Object> initializationContext) {
        this.loadedClassesRetriever = functionProvider.getOrBuildObject(GetLoadedClassesFunction.class, initializationContext);
    }

    void replaceConsulterWithDeepConsulter(ObjectProvider functionProvider, Map<Object, Object> initializationContext) {
        this.consulterRetriever = functionProvider.getOrBuildObject(DeepConsulterSupplyFunction.class, initializationContext);
    }

    void initClassLoaderDelegateClass(ObjectProvider functionProvider, Map<Object, Object> initializationContext) {
        this.classLoaderDelegateClass = (Class)functionProvider.getOrBuildObject(ClassLoaderDelegateClassSupplier.class, initializationContext).get();
    }

    void initBuiltinClassLoaderClass(ObjectProvider functionProvider, Map<Object, Object> initializationContext) {
        this.builtinClassLoaderClass = (Class)functionProvider.getOrBuildObject(BuiltinClassLoaderClassSupplier.class, initializationContext).get();
    }

    void initPackageRetriever(ObjectProvider functionProvider, Map<Object, Object> initializationContext) {
        this.packageRetriever = functionProvider.getOrBuildObject(GetPackageFunction.class, initializationContext);
    }

    void initFieldValueSetter(ObjectProvider functionProvider, Map<Object, Object> initializationContext) {
        this.fieldValueSetter = functionProvider.getOrBuildObject(SetFieldValueFunction.class, initializationContext);
    }

    void initFieldValueRetriever(ObjectProvider functionProvider, Map<Object, Object> initializationContext) {
        this.fieldValueRetriever = functionProvider.getOrBuildObject(GetFieldValueFunction.class, initializationContext);
    }

    void initAllocateInstanceInvoker(ObjectProvider functionProvider, Map<Object, Object> initializationContext) {
        this.allocateInstanceInvoker = functionProvider.getOrBuildObject(AllocateInstanceFunction.class, initializationContext);
    }

    void initMethodInvoker(ObjectProvider functionProvider, Map<Object, Object> initializationContext) {
        this.methodInvoker = functionProvider.getOrBuildObject(MethodInvokeMethodHandleSupplier.class, initializationContext).get();
    }

    void initConstructorInvoker(ObjectProvider functionProvider, Map<Object, Object> initializationContext) {
        this.constructorInvoker = functionProvider.getOrBuildObject(ConstructorInvokeMethodHandleSupplier.class, initializationContext).get();
    }

    void initAccessibleSetter(ObjectProvider functionProvider, Map<Object, Object> initializationContext) {
        this.accessibleSetter = functionProvider.getOrBuildObject(SetAccessibleFunction.class, initializationContext);
    }

    void initDeclaredConstructorsRetriever(ObjectProvider functionProvider, Map<Object, Object> initializationContext) {
        this.declaredConstructorsRetriever = functionProvider.getOrBuildObject(GetDeclaredConstructorsMethodHandleSupplier.class, initializationContext).get();
    }

    void initDeclaredMethodsRetriever(ObjectProvider functionProvider, Map<Object, Object> initializationContext) {
        this.declaredMethodsRetriever = functionProvider.getOrBuildObject(GetDeclaredMethodsMethodHandleSupplier.class, initializationContext).get();
    }

    void initDeclaredFieldsRetriever(ObjectProvider functionProvider, Map<Object, Object> initializationContext) {
        this.declaredFieldsRetriever = functionProvider.getOrBuildObject(GetDeclaredFieldsMethodHandleSupplier.class, initializationContext).get();
    }

    void initHookClassDefiner(ObjectProvider functionProvider, Map<Object, Object> initializationContext) {
        this.hookClassDefiner = functionProvider.getOrBuildObject(DefineHookClassFunction.class, initializationContext);
    }

    void initConsulterRetriever(ObjectProvider functionProvider, Map<Object, Object> initializationContext) {
        this.consulterRetriever = functionProvider.getOrBuildObject(ConsulterSupplyFunction.class, initializationContext);
    }

    @Override
    public <T> T throwException(Object exceptionOrMessage, Object ... placeHolderReplacements) {
        return this.exceptionThrower.apply(exceptionOrMessage, placeHolderReplacements);
    }

    @Override
    public void setAccessible(AccessibleObject object, boolean flag) {
        this.accessibleSetter.accept(object, flag);
    }

    @Override
    public Class<?> defineHookClass(Class<?> clientClass, byte[] byteCode) {
        return this.hookClassDefiner.apply(clientClass, byteCode);
    }

    @Override
    public Package getPackage(ClassLoader classLoader, String packageName) {
        return this.packageRetriever.apply(classLoader, packageName);
    }

    @Override
    public Collection<Class<?>> retrieveLoadedClasses(ClassLoader classLoader) {
        return this.loadedClassesRetriever.apply(classLoader);
    }

    @Override
    public Map<String, ?> retrieveLoadedPackages(ClassLoader classLoader) {
        return this.loadedPackagesRetriever.apply(classLoader);
    }

    @Override
    public <T> T getFieldValue(Object target, Field field) {
        return (T)this.fieldValueRetriever.apply(target, field);
    }

    @Override
    public void setFieldValue(Object target, Field field, Object value) {
        this.fieldValueSetter.accept(target, field, value);
    }

    @Override
    public <T> T allocateInstance(Class<?> cls) {
        return (T)this.allocateInstanceInvoker.apply(cls);
    }

    @Override
    public boolean isBuiltinClassLoader(ClassLoader classLoader) {
        return this.builtinClassLoaderClass != null && this.builtinClassLoaderClass.isAssignableFrom(classLoader.getClass());
    }

    @Override
    public boolean isClassLoaderDelegate(ClassLoader classLoader) {
        return this.classLoaderDelegateClass != null && this.classLoaderDelegateClass.isAssignableFrom(classLoader.getClass());
    }

    @Override
    public Class<?> getBuiltinClassLoaderClass() {
        return this.builtinClassLoaderClass;
    }

    @Override
    public Class<?> getClassLoaderDelegateClass() {
        return this.classLoaderDelegateClass;
    }

    @Override
    public MethodHandles.Lookup getConsulter(Class<?> cls) {
        return this.consulterRetriever.apply(cls);
    }

    @Override
    public <T> T invoke(Method method, Object target, Object[] params) {
        try {
            return (T)this.methodInvoker.invoke(method, target, params);
        }
        catch (Throwable exc) {
            return this.throwException(exc, new Object[0]);
        }
    }

    @Override
    public <T> T newInstance(Constructor<T> ctor, Object[] params) {
        try {
            return (T)this.constructorInvoker.invoke(ctor, params);
        }
        catch (Throwable exc) {
            return this.throwException(exc, new Object[0]);
        }
    }

    @Override
    public Field[] getDeclaredFields(Class<?> cls) {
        try {
            return this.declaredFieldsRetriever.invoke(cls, false);
        }
        catch (Throwable exc) {
            return (Field[])this.throwException(exc, new Object[0]);
        }
    }

    @Override
    public <T> Constructor<T>[] getDeclaredConstructors(Class<T> cls) {
        try {
            return this.declaredConstructorsRetriever.invoke(cls, false);
        }
        catch (Throwable exc) {
            return (Constructor[])this.throwException(exc, new Object[0]);
        }
    }

    @Override
    public Method[] getDeclaredMethods(Class<?> cls) {
        try {
            return this.declaredMethodsRetriever.invoke(cls, false);
        }
        catch (Throwable exc) {
            return (Method[])this.throwException(exc, new Object[0]);
        }
    }

    @Override
    public void close() {
        this.exceptionThrower = null;
        this.allocateInstanceInvoker = null;
        this.fieldValueRetriever = null;
        this.fieldValueSetter = null;
        this.hookClassDefiner = null;
        this.consulterRetriever = null;
        this.declaredFieldsRetriever = null;
        this.declaredMethodsRetriever = null;
        this.declaredConstructorsRetriever = null;
        this.accessibleSetter = null;
        this.constructorInvoker = null;
        this.packageRetriever = null;
        this.methodInvoker = null;
        this.classLoaderDelegateClass = null;
        this.builtinClassLoaderClass = null;
        this.loadedClassesRetriever = null;
        this.loadedPackagesRetriever = null;
    }
}

