/*
 * Decompiled with CFR 0.152.
 */
package io.github.toolfactory.jvm.function.catalog;

import io.github.toolfactory.jvm.function.catalog.GetDeclaredFieldFunction;
import io.github.toolfactory.jvm.function.catalog.UnsafeSupplier;
import io.github.toolfactory.jvm.function.template.Function;
import io.github.toolfactory.jvm.util.ObjectProvider;
import io.github.toolfactory.narcissus.Narcissus;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import sun.misc.Unsafe;

public abstract class GetLoadedClassesFunction
implements Function<ClassLoader, Collection<Class<?>>> {

    public static abstract class Native
    extends GetLoadedClassesFunction {

        public static class ForJava7
        extends Native {
            Field classesField;

            public ForJava7(Map<Object, Object> context) {
                ObjectProvider functionProvider = ObjectProvider.get(context);
                GetDeclaredFieldFunction getDeclaredFieldFunction = functionProvider.getOrBuildObject(GetDeclaredFieldFunction.class, context);
                this.classesField = (Field)getDeclaredFieldFunction.apply(ClassLoader.class, "classes");
            }

            @Override
            public Collection<Class<?>> apply(ClassLoader classLoader) {
                return (Collection)Narcissus.getField((Object)classLoader, (Field)this.classesField);
            }
        }
    }

    public static class ForJava7
    extends GetLoadedClassesFunction {
        final Unsafe unsafe;
        final Long loadedClassesVectorMemoryOffset;

        public ForJava7(Map<Object, Object> context) {
            ObjectProvider functionProvider = ObjectProvider.get(context);
            this.unsafe = (Unsafe)functionProvider.getOrBuildObject(UnsafeSupplier.class, context).get();
            GetDeclaredFieldFunction getDeclaredFieldFunction = functionProvider.getOrBuildObject(GetDeclaredFieldFunction.class, context);
            this.loadedClassesVectorMemoryOffset = this.unsafe.objectFieldOffset((Field)getDeclaredFieldFunction.apply(ClassLoader.class, "classes"));
        }

        @Override
        public Collection<Class<?>> apply(ClassLoader classLoader) {
            return (Collection)this.unsafe.getObject(classLoader, this.loadedClassesVectorMemoryOffset);
        }
    }
}

