/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.protobuf;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.protobuf.ProtoInputStream;
import java.io.InputStream;

public class ProtoUtils {
    public static <T extends MessageLite> MethodDescriptor.Marshaller<T> marshaller(T defaultInstance) {
        Parser parserGeneric;
        final Parser parser = parserGeneric = defaultInstance.getParserForType();
        return new MethodDescriptor.Marshaller<T>(){

            public InputStream stream(T value) {
                return new ProtoInputStream((MessageLite)value, (Parser<?>)parser);
            }

            public T parse(InputStream stream) {
                ProtoInputStream protoStream;
                if (stream instanceof ProtoInputStream && (protoStream = (ProtoInputStream)stream).parser() == parser) {
                    MessageLite message = ((ProtoInputStream)stream).message();
                    return message;
                }
                try {
                    return this.parseFrom(stream);
                }
                catch (InvalidProtocolBufferException ipbe) {
                    throw Status.INTERNAL.withDescription("Invalid protobuf byte sequence").withCause((Throwable)ipbe).asRuntimeException();
                }
            }

            private T parseFrom(InputStream stream) throws InvalidProtocolBufferException {
                CodedInputStream codedInput = CodedInputStream.newInstance((InputStream)stream);
                codedInput.setSizeLimit(Integer.MAX_VALUE);
                MessageLite message = (MessageLite)parser.parseFrom(codedInput);
                try {
                    codedInput.checkLastTagWas(0);
                    return message;
                }
                catch (InvalidProtocolBufferException e) {
                    e.setUnfinishedMessage(message);
                    throw e;
                }
            }
        };
    }

    public static <T extends Message> Metadata.Key<T> keyForProto(final T instance) {
        return Metadata.Key.of((String)(instance.getDescriptorForType().getFullName() + "-bin"), (Metadata.BinaryMarshaller)new Metadata.BinaryMarshaller<T>(){

            public byte[] toBytes(T value) {
                return value.toByteArray();
            }

            public T parseBytes(byte[] serialized) {
                try {
                    return (Message)instance.getParserForType().parseFrom(serialized);
                }
                catch (InvalidProtocolBufferException ipbe) {
                    throw new IllegalArgumentException(ipbe);
                }
            }
        });
    }

    private ProtoUtils() {
    }
}

