/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http;

import io.helidon.common.buffers.Ascii;
import io.helidon.http.HeaderName;
import io.helidon.http.HeaderNameEnum;
import io.helidon.http.HeaderNameImpl;

public final class HeaderNames {
    public static final HeaderName ACCEPT = HeaderNameEnum.ACCEPT;
    public static final HeaderName ACCEPT_CHARSET = HeaderNameEnum.ACCEPT_CHARSET;
    public static final HeaderName ACCEPT_ENCODING = HeaderNameEnum.ACCEPT_ENCODING;
    public static final HeaderName ACCEPT_LANGUAGE = HeaderNameEnum.ACCEPT_LANGUAGE;
    public static final HeaderName ACCEPT_DATETIME = HeaderNameEnum.ACCEPT_DATETIME;
    public static final HeaderName ACCESS_CONTROL_ALLOW_CREDENTIALS = HeaderNameEnum.ACCESS_CONTROL_ALLOW_CREDENTIALS;
    public static final HeaderName ACCESS_CONTROL_ALLOW_HEADERS = HeaderNameEnum.ACCESS_CONTROL_ALLOW_HEADERS;
    public static final HeaderName ACCESS_CONTROL_ALLOW_METHODS = HeaderNameEnum.ACCESS_CONTROL_ALLOW_METHODS;
    public static final HeaderName ACCESS_CONTROL_ALLOW_ORIGIN = HeaderNameEnum.ACCESS_CONTROL_ALLOW_ORIGIN;
    public static final HeaderName ACCESS_CONTROL_EXPOSE_HEADERS = HeaderNameEnum.ACCESS_CONTROL_EXPOSE_HEADERS;
    public static final HeaderName ACCESS_CONTROL_MAX_AGE = HeaderNameEnum.ACCESS_CONTROL_MAX_AGE;
    public static final HeaderName ACCESS_CONTROL_REQUEST_HEADERS = HeaderNameEnum.ACCESS_CONTROL_REQUEST_HEADERS;
    public static final HeaderName ACCESS_CONTROL_REQUEST_METHOD = HeaderNameEnum.ACCESS_CONTROL_REQUEST_METHOD;
    public static final HeaderName AUTHORIZATION = HeaderNameEnum.AUTHORIZATION;
    public static final HeaderName COOKIE = HeaderNameEnum.COOKIE;
    public static final HeaderName EXPECT = HeaderNameEnum.EXPECT;
    public static final HeaderName FORWARDED = HeaderNameEnum.FORWARDED;
    public static final HeaderName FROM = HeaderNameEnum.FROM;
    public static final HeaderName HOST = HeaderNameEnum.HOST;
    public static final String HOST_STRING = "Host";
    public static final HeaderName IF_MATCH = HeaderNameEnum.IF_MATCH;
    public static final HeaderName IF_MODIFIED_SINCE = HeaderNameEnum.IF_MODIFIED_SINCE;
    public static final HeaderName IF_NONE_MATCH = HeaderNameEnum.IF_NONE_MATCH;
    public static final HeaderName IF_RANGE = HeaderNameEnum.IF_RANGE;
    public static final HeaderName IF_UNMODIFIED_SINCE = HeaderNameEnum.IF_UNMODIFIED_SINCE;
    public static final HeaderName MAX_FORWARDS = HeaderNameEnum.MAX_FORWARDS;
    public static final HeaderName ORIGIN = HeaderNameEnum.ORIGIN;
    public static final HeaderName PROXY_AUTHENTICATE = HeaderNameEnum.PROXY_AUTHENTICATE;
    public static final HeaderName PROXY_AUTHORIZATION = HeaderNameEnum.PROXY_AUTHORIZATION;
    public static final HeaderName RANGE = HeaderNameEnum.RANGE;
    public static final HeaderName REFERER = HeaderNameEnum.REFERER;
    public static final HeaderName REFRESH = HeaderNameEnum.REFRESH;
    public static final HeaderName TE = HeaderNameEnum.TE;
    public static final HeaderName USER_AGENT = HeaderNameEnum.USER_AGENT;
    public static final HeaderName VIA = HeaderNameEnum.VIA;
    public static final HeaderName ACCEPT_PATCH = HeaderNameEnum.ACCEPT_PATCH;
    public static final HeaderName ACCEPT_RANGES = HeaderNameEnum.ACCEPT_RANGES;
    public static final HeaderName AGE = HeaderNameEnum.AGE;
    public static final HeaderName ALLOW = HeaderNameEnum.ALLOW;
    public static final HeaderName ALT_SVC = HeaderNameEnum.ALT_SVC;
    public static final HeaderName CACHE_CONTROL = HeaderNameEnum.CACHE_CONTROL;
    public static final HeaderName CONNECTION = HeaderNameEnum.CONNECTION;
    public static final HeaderName CONTENT_DISPOSITION = HeaderNameEnum.CONTENT_DISPOSITION;
    public static final HeaderName CONTENT_ENCODING = HeaderNameEnum.CONTENT_ENCODING;
    public static final HeaderName CONTENT_LANGUAGE = HeaderNameEnum.CONTENT_LANGUAGE;
    public static final HeaderName CONTENT_LENGTH = HeaderNameEnum.CONTENT_LENGTH;
    public static final HeaderName CONTENT_LOCATION = HeaderNameEnum.CONTENT_LOCATION;
    public static final HeaderName CONTENT_RANGE = HeaderNameEnum.CONTENT_RANGE;
    public static final HeaderName CONTENT_TYPE = HeaderNameEnum.CONTENT_TYPE;
    public static final HeaderName DATE = HeaderNameEnum.DATE;
    public static final HeaderName ETAG = HeaderNameEnum.ETAG;
    public static final HeaderName EXPIRES = HeaderNameEnum.EXPIRES;
    public static final HeaderName LAST_MODIFIED = HeaderNameEnum.LAST_MODIFIED;
    public static final HeaderName LINK = HeaderNameEnum.LINK;
    public static final HeaderName LOCATION = HeaderNameEnum.LOCATION;
    public static final HeaderName PRAGMA = HeaderNameEnum.PRAGMA;
    public static final HeaderName PUBLIC_KEY_PINS = HeaderNameEnum.PUBLIC_KEY_PINS;
    public static final HeaderName RETRY_AFTER = HeaderNameEnum.RETRY_AFTER;
    public static final HeaderName SERVER = HeaderNameEnum.SERVER;
    public static final HeaderName SET_COOKIE = HeaderNameEnum.SET_COOKIE;
    public static final HeaderName SET_COOKIE2 = HeaderNameEnum.SET_COOKIE2;
    public static final HeaderName STRICT_TRANSPORT_SECURITY = HeaderNameEnum.STRICT_TRANSPORT_SECURITY;
    public static final HeaderName TRAILER = HeaderNameEnum.TRAILER;
    public static final HeaderName TRANSFER_ENCODING = HeaderNameEnum.TRANSFER_ENCODING;
    public static final HeaderName TSV = HeaderNameEnum.TSV;
    public static final HeaderName UPGRADE = HeaderNameEnum.UPGRADE;
    public static final HeaderName VARY = HeaderNameEnum.VARY;
    public static final HeaderName WARNING = HeaderNameEnum.WARNING;
    public static final HeaderName WWW_AUTHENTICATE = HeaderNameEnum.WWW_AUTHENTICATE;
    public static final HeaderName X_HELIDON_CN = HeaderNameEnum.X_HELIDON_CN;
    public static final HeaderName X_FORWARDED_FOR = HeaderNameEnum.X_FORWARDED_FOR;
    public static final HeaderName X_FORWARDED_HOST = HeaderNameEnum.X_FORWARDED_HOST;
    public static final HeaderName X_FORWARDED_PORT = HeaderNameEnum.X_FORWARDED_PORT;
    public static final HeaderName X_FORWARDED_PREFIX = HeaderNameEnum.X_FORWARDED_PREFIX;
    public static final HeaderName X_FORWARDED_PROTO = HeaderNameEnum.X_FORWARDED_PROTO;

    private HeaderNames() {
    }

    public static HeaderName create(String name) {
        HeaderName headerName = HeaderNameEnum.byCapitalizedName(name);
        if (headerName == null) {
            return new HeaderNameImpl(Ascii.toLowerCase((String)name), name);
        }
        return headerName;
    }

    public static HeaderName create(String lowerCase, String defaultCase) {
        HeaderName headerName = HeaderNameEnum.byName(lowerCase);
        if (headerName == null) {
            return new HeaderNameImpl(lowerCase, defaultCase);
        }
        return headerName;
    }

    public static HeaderName createFromLowercase(String lowerCase) {
        HeaderName headerName = HeaderNameEnum.byName(lowerCase);
        if (headerName == null) {
            return new HeaderNameImpl(lowerCase, lowerCase);
        }
        return headerName;
    }
}

