/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http;

import io.helidon.http.Method;
import io.helidon.http.MethodPredicate;
import java.util.Set;

class MethodPredicates {
    MethodPredicates() {
    }

    static class MethodsPredicate
    implements MethodPredicate {
        private final Set<Method> methods;

        MethodsPredicate(Method ... methods) {
            this.methods = Set.of(methods);
        }

        @Override
        public boolean test(Method method) {
            return this.methods.contains(method);
        }

        @Override
        public Set<Method> acceptedMethods() {
            return this.methods;
        }

        public String toString() {
            return String.join((CharSequence)", ", this.methods.stream().map(Method::text).toList());
        }
    }

    static class SingleMethodPredicate
    implements MethodPredicate {
        private final Method method;
        private final Set<Method> accepted;

        SingleMethodPredicate(Method method) {
            this.method = method;
            this.accepted = Set.of(method);
        }

        @Override
        public boolean test(Method method) {
            return method.equals(this.method);
        }

        @Override
        public Set<Method> acceptedMethods() {
            return this.accepted;
        }

        public String toString() {
            return this.method.text();
        }
    }

    static class SingleMethodEnumPredicate
    implements MethodPredicate {
        private final Method method;
        private final Set<Method> accepted;

        SingleMethodEnumPredicate(Method method) {
            this.method = method;
            this.accepted = Set.of(method);
        }

        @Override
        public boolean test(Method method) {
            return method == this.method;
        }

        @Override
        public Set<Method> acceptedMethods() {
            return this.accepted;
        }

        public String toString() {
            return this.method.text();
        }
    }

    static class TruePredicate
    implements MethodPredicate {
        private static final TruePredicate INSTANCE = new TruePredicate();

        TruePredicate() {
        }

        static MethodPredicate get() {
            return INSTANCE;
        }

        @Override
        public boolean test(Method t) {
            return true;
        }

        @Override
        public Set<Method> acceptedMethods() {
            return Set.of();
        }

        public String toString() {
            return "(any method)";
        }
    }
}

