/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing;

import io.jaegertracing.LogData;
import io.jaegertracing.Reference;
import io.jaegertracing.SpanContext;
import io.jaegertracing.Tracer;
import io.opentracing.tag.Tags;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Span
implements io.opentracing.Span {
    private static final Logger logger = LoggerFactory.getLogger(Span.class);
    private final Tracer tracer;
    private final long startTimeMicroseconds;
    private final long startTimeNanoTicks;
    private final boolean computeDurationViaNanoTicks;
    private final Map<String, Object> tags;
    private long durationMicroseconds;
    private String operationName;
    private final List<Reference> references;
    private SpanContext context;
    private List<LogData> logs;
    private boolean finished = false;

    Span(Tracer tracer, String operationName, SpanContext context, long startTimeMicroseconds, long startTimeNanoTicks, boolean computeDurationViaNanoTicks, Map<String, Object> tags, List<Reference> references) {
        this.tracer = tracer;
        this.operationName = operationName;
        this.context = context;
        this.startTimeMicroseconds = startTimeMicroseconds;
        this.startTimeNanoTicks = startTimeNanoTicks;
        this.computeDurationViaNanoTicks = computeDurationViaNanoTicks;
        this.tags = new HashMap<String, Object>();
        this.references = references != null ? new ArrayList<Reference>(references) : null;
        for (Map.Entry<String, Object> tag : tags.entrySet()) {
            this.setTagAsObject(tag.getKey(), tag.getValue());
        }
    }

    public long getStart() {
        return this.startTimeMicroseconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDuration() {
        Span span = this;
        synchronized (span) {
            return this.durationMicroseconds;
        }
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    public List<Reference> getReferences() {
        if (this.references == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.references);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getTags() {
        Span span = this;
        synchronized (span) {
            return Collections.unmodifiableMap(this.tags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Span setOperationName(String operationName) {
        Span span = this;
        synchronized (span) {
            this.operationName = operationName;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOperationName() {
        Span span = this;
        synchronized (span) {
            return this.operationName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getServiceName() {
        Span span = this;
        synchronized (span) {
            return this.getTracer().getServiceName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LogData> getLogs() {
        Span span = this;
        synchronized (span) {
            if (this.logs == null) {
                return null;
            }
            return Collections.unmodifiableList(this.logs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Span setBaggageItem(String key, String value) {
        if (key == null || value == null && this.context.getBaggageItem(key) == null) {
            return this;
        }
        Span span = this;
        synchronized (span) {
            this.context = this.tracer.setBaggage(this, key, value);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getBaggageItem(String key) {
        Span span = this;
        synchronized (span) {
            return this.context.getBaggageItem(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Span span = this;
        synchronized (span) {
            return this.context.contextAsString() + " - " + this.operationName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SpanContext context() {
        Span span = this;
        synchronized (span) {
            return this.context;
        }
    }

    @Override
    public void finish() {
        if (this.computeDurationViaNanoTicks) {
            long nanoDuration = this.tracer.clock().currentNanoTicks() - this.startTimeNanoTicks;
            this.finishWithDuration(nanoDuration / 1000L);
        } else {
            this.finish(this.tracer.clock().currentTimeMicros());
        }
    }

    @Override
    public void finish(long finishMicros) {
        this.finishWithDuration(finishMicros - this.startTimeMicroseconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishWithDuration(long durationMicros) {
        Span span = this;
        synchronized (span) {
            if (this.finished) {
                logger.warn("Span has already been finished; will not be reported again.");
                return;
            }
            this.finished = true;
            this.durationMicroseconds = durationMicros;
        }
        if (this.context.isSampled()) {
            this.tracer.reportSpan(this);
        }
    }

    @Override
    public synchronized Span setTag(String key, String value) {
        return this.setTagAsObject(key, value);
    }

    @Override
    public synchronized Span setTag(String key, boolean value) {
        return this.setTagAsObject(key, value);
    }

    @Override
    public synchronized Span setTag(String key, Number value) {
        return this.setTagAsObject(key, value);
    }

    private Span setTagAsObject(String key, Object value) {
        if (key.equals(Tags.SAMPLING_PRIORITY.getKey()) && value instanceof Number) {
            int priority = ((Number)value).intValue();
            byte newFlags = priority > 0 ? (byte)(this.context.getFlags() | 1 | 2) : (byte)(this.context.getFlags() & 0xFFFFFFFE);
            this.context = this.context.withFlags(newFlags);
        }
        if (this.context.isSampled()) {
            this.tags.put(key, value);
        }
        return this;
    }

    @Override
    public Span log(Map<String, ?> fields) {
        return this.log(this.tracer.clock().currentTimeMicros(), (Map)fields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Span log(long timestampMicroseconds, Map<String, ?> fields) {
        Span span = this;
        synchronized (span) {
            if (fields == null) {
                return this;
            }
            if (this.context.isSampled()) {
                if (this.tracer.isExpandExceptionLogs()) {
                    fields = Span.addExceptionLogs(fields);
                }
                if (this.logs == null) {
                    this.logs = new ArrayList<LogData>();
                }
                this.logs.add(new LogData(timestampMicroseconds, fields));
            }
            return this;
        }
    }

    @Override
    public Span log(String event) {
        return this.log(this.tracer.clock().currentTimeMicros(), event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Span log(long timestampMicroseconds, String event) {
        Span span = this;
        synchronized (span) {
            if (event == null) {
                return this;
            }
            if (this.context.isSampled()) {
                if (this.logs == null) {
                    this.logs = new ArrayList<LogData>();
                }
                this.logs.add(new LogData(timestampMicroseconds, event));
            }
            return this;
        }
    }

    private static Map<String, ?> addExceptionLogs(Map<String, ?> fields) {
        String message;
        Object ex = fields.get("error.object");
        if (!(ex instanceof Throwable)) {
            return fields;
        }
        HashMap errorFields = new HashMap(fields);
        Throwable loggedException = (Throwable)ex;
        if (fields.get("error.kind") == null) {
            errorFields.put("error.kind", loggedException.getClass().getName());
        }
        if (fields.get("message") == null && (message = loggedException.getMessage()) != null) {
            errorFields.put("message", message);
        }
        if (fields.get("stack") == null) {
            StringWriter sw = new StringWriter();
            loggedException.printStackTrace(new PrintWriter(sw));
            errorFields.put("stack", sw.toString());
        }
        return errorFields;
    }
}

