/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.senders;

import io.jaegertracing.exceptions.SenderException;
import io.jaegertracing.senders.ThriftSender;
import io.jaegertracing.thrift.senders.ThriftSenderBase;
import io.jaegertracing.thriftjava.Batch;
import io.jaegertracing.thriftjava.Process;
import io.jaegertracing.thriftjava.Span;
import jaeger.okhttp3.Credentials;
import jaeger.okhttp3.HttpUrl;
import jaeger.okhttp3.Interceptor;
import jaeger.okhttp3.MediaType;
import jaeger.okhttp3.OkHttpClient;
import jaeger.okhttp3.Request;
import jaeger.okhttp3.RequestBody;
import jaeger.okhttp3.Response;
import java.io.IOException;
import java.util.List;

public class HttpSender
extends ThriftSender {
    private static final String HTTP_COLLECTOR_JAEGER_THRIFT_FORMAT_PARAM = "format=jaeger.thrift";
    private static final int ONE_MB_IN_BYTES = 0x100000;
    private static final MediaType MEDIA_TYPE_THRIFT = MediaType.parse("application/x-thrift");
    private final OkHttpClient httpClient;
    private final Request.Builder requestBuilder;

    public HttpSender(String endpoint) {
        this(new Builder(endpoint));
    }

    @Deprecated
    public HttpSender(String endpoint, int maxPacketSize) {
        this(new Builder(endpoint).withMaxPacketSize(maxPacketSize));
    }

    @Deprecated
    public HttpSender(String endpoint, OkHttpClient client) {
        this(new Builder(endpoint).withClient(client));
    }

    @Deprecated
    public HttpSender(String endpoint, int maxPacketSize, OkHttpClient client) {
        this(new Builder(endpoint).withClient(client).withMaxPacketSize(maxPacketSize));
    }

    private HttpSender(Builder builder) {
        super(ThriftSenderBase.ProtocolType.Binary, builder.maxPacketSize);
        HttpUrl collectorUrl = HttpUrl.parse(String.format("%s?%s", builder.endpoint, HTTP_COLLECTOR_JAEGER_THRIFT_FORMAT_PARAM));
        if (collectorUrl == null) {
            throw new IllegalArgumentException("Could not parse url.");
        }
        this.httpClient = builder.clientBuilder.build();
        this.requestBuilder = new Request.Builder().url(collectorUrl);
    }

    @Override
    public void send(Process process, List<Span> spans) throws SenderException {
        Response response;
        Batch batch = new Batch(process, spans);
        byte[] bytes = null;
        try {
            bytes = this.serialize(batch);
        }
        catch (Exception e) {
            throw new SenderException(String.format("Failed to serialize %d spans", spans.size()), e, spans.size());
        }
        RequestBody body = RequestBody.create(MEDIA_TYPE_THRIFT, bytes);
        Request request = this.requestBuilder.post(body).build();
        try {
            response = this.httpClient.newCall(request).execute();
        }
        catch (IOException e) {
            throw new SenderException(String.format("Could not send %d spans", spans.size()), e, spans.size());
        }
        if (!response.isSuccessful()) {
            String responseBody;
            try {
                responseBody = response.body() != null ? response.body().string() : "null";
            }
            catch (IOException e) {
                responseBody = "unable to read response";
            }
            String exceptionMessage = String.format("Could not send %d spans, response %d: %s", spans.size(), response.code(), responseBody);
            throw new SenderException(exceptionMessage, null, spans.size());
        }
    }

    @Override
    public String toString() {
        return "HttpSender()";
    }

    public static class Builder {
        private final String endpoint;
        private int maxPacketSize = 0x100000;
        private Interceptor authInterceptor;
        private OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();

        public Builder(String endpoint) {
            this.endpoint = endpoint;
        }

        public Builder withClient(OkHttpClient client) {
            this.clientBuilder = client.newBuilder();
            return this;
        }

        public Builder withMaxPacketSize(int maxPacketSizeBytes) {
            this.maxPacketSize = maxPacketSizeBytes;
            return this;
        }

        public Builder withAuth(String username, String password) {
            this.authInterceptor = this.getAuthInterceptor(Credentials.basic(username, password));
            return this;
        }

        public Builder withAuth(String authToken) {
            this.authInterceptor = this.getAuthInterceptor("Bearer " + authToken);
            return this;
        }

        public HttpSender build() {
            if (this.authInterceptor != null) {
                this.clientBuilder.addInterceptor(this.authInterceptor);
            }
            return new HttpSender(this);
        }

        private Interceptor getAuthInterceptor(final String headerValue) {
            return new Interceptor(){

                @Override
                public Response intercept(Interceptor.Chain chain) throws IOException {
                    return chain.proceed(chain.request().newBuilder().addHeader("Authorization", headerValue).build());
                }
            };
        }
    }
}

