/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.senders;

import io.jaegertracing.Span;
import io.jaegertracing.exceptions.SenderException;
import io.jaegertracing.reporters.protocols.JaegerThriftSpanConverter;
import io.jaegertracing.senders.Sender;
import io.jaegertracing.thrift.senders.ThriftSenderBase;
import io.jaegertracing.thriftjava.Process;
import java.util.ArrayList;
import java.util.List;

public abstract class ThriftSender
extends ThriftSenderBase
implements Sender {
    private Process process;
    private int processBytesSize;
    private List<io.jaegertracing.thriftjava.Span> spanBuffer = new ArrayList<io.jaegertracing.thriftjava.Span>();
    private int byteBufferSize;

    public ThriftSender(ThriftSenderBase.ProtocolType protocolType, int maxPacketSize) {
        super(protocolType, maxPacketSize);
    }

    @Override
    public int append(Span span) throws SenderException {
        int n;
        io.jaegertracing.thriftjava.Span thriftSpan;
        int spanSize;
        if (this.process == null) {
            this.process = new Process(span.getTracer().getServiceName());
            this.process.setTags(JaegerThriftSpanConverter.buildTags(span.getTracer().tags()));
            this.processBytesSize = this.calculateProcessSize(this.process);
            this.byteBufferSize += this.processBytesSize;
        }
        if ((spanSize = this.calculateSpanSize(thriftSpan = JaegerThriftSpanConverter.convertSpan(span))) > this.getMaxSpanBytes()) {
            throw new SenderException(String.format("ThriftSender received a span that was too large, size = %d, max = %d", spanSize, this.getMaxSpanBytes()), null, 1);
        }
        this.byteBufferSize += spanSize;
        if (this.byteBufferSize <= this.getMaxSpanBytes()) {
            this.spanBuffer.add(thriftSpan);
            if (this.byteBufferSize < this.getMaxSpanBytes()) {
                return 0;
            }
            return this.flush();
        }
        try {
            n = this.flush();
        }
        catch (SenderException e) {
            throw new SenderException(e.getMessage(), e.getCause(), e.getDroppedSpanCount() + 1);
        }
        this.spanBuffer.add(thriftSpan);
        this.byteBufferSize = this.processBytesSize + spanSize;
        return n;
    }

    protected int calculateProcessSize(Process proc) throws SenderException {
        try {
            return this.getSize(proc);
        }
        catch (Exception e) {
            throw new SenderException("ThriftSender failed writing Process to memory buffer.", e, 1);
        }
    }

    protected int calculateSpanSize(io.jaegertracing.thriftjava.Span span) throws SenderException {
        try {
            return this.getSize(span);
        }
        catch (Exception e) {
            throw new SenderException("ThriftSender failed writing Span to memory buffer.", e, 1);
        }
    }

    public abstract void send(Process var1, List<io.jaegertracing.thriftjava.Span> var2) throws SenderException;

    @Override
    public int flush() throws SenderException {
        if (this.spanBuffer.isEmpty()) {
            return 0;
        }
        int n = this.spanBuffer.size();
        try {
            this.send(this.process, this.spanBuffer);
        }
        catch (SenderException e) {
            throw new SenderException("Failed to flush spans.", e, n);
        }
        finally {
            this.spanBuffer.clear();
            this.byteBufferSize = this.processBytesSize;
        }
        return n;
    }

    @Override
    public int close() throws SenderException {
        return this.flush();
    }

    @Override
    public String toString() {
        return "ThriftSender(process=" + this.process + ", processBytesSize=" + this.processBytesSize + ", byteBufferSize=" + this.byteBufferSize + ")";
    }
}

