/*
 * Copyright (c) 2016, Uber Technologies, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */

package io.jaegertracing.propagation;

// TODO profile and cache prefixed and unprefixed keys if necessary
public final class PrefixedKeys {
  public String prefixedKey(String key, String prefix) {
    return prefix + key;
  }

  public String unprefixedKey(String key, String prefix) {
    return key.substring(prefix.length());
  }
}
