/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.internal.samplers;

import io.jaegertracing.internal.samplers.ProbabilisticSampler;
import io.jaegertracing.internal.samplers.RateLimitingSampler;
import io.jaegertracing.internal.samplers.SamplingStatus;
import io.jaegertracing.spi.Sampler;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;

public final class GuaranteedThroughputSampler
implements Sampler {
    public static final String TYPE = "lowerbound";
    private ProbabilisticSampler probabilisticSampler;
    private RateLimitingSampler lowerBoundSampler;
    private Map<String, Object> tags;

    GuaranteedThroughputSampler(double samplingRate, double lowerBound) {
        this.tags = new HashMap<String, Object>();
        this.tags.put("sampler.type", TYPE);
        this.tags.put("sampler.param", samplingRate);
        this.probabilisticSampler = new ProbabilisticSampler(samplingRate);
        this.lowerBoundSampler = new RateLimitingSampler(lowerBound);
    }

    public synchronized boolean update(double samplingRate, double lowerBound) {
        boolean isUpdated = false;
        if (samplingRate != this.probabilisticSampler.getSamplingRate()) {
            this.probabilisticSampler = new ProbabilisticSampler(samplingRate);
            this.tags.put("sampler.param", samplingRate);
            isUpdated = true;
        }
        if (lowerBound != this.lowerBoundSampler.getMaxTracesPerSecond()) {
            this.lowerBoundSampler = new RateLimitingSampler(lowerBound);
            isUpdated = true;
        }
        return isUpdated;
    }

    @Override
    public synchronized SamplingStatus sample(String operation, long id) {
        SamplingStatus probabilisticSamplingStatus = this.probabilisticSampler.sample(operation, id);
        SamplingStatus lowerBoundSamplingStatus = this.lowerBoundSampler.sample(operation, id);
        if (probabilisticSamplingStatus.isSampled()) {
            return probabilisticSamplingStatus;
        }
        return SamplingStatus.of(lowerBoundSamplingStatus.isSampled(), this.tags);
    }

    @Override
    public synchronized void close() {
        this.probabilisticSampler.close();
        this.lowerBoundSampler.close();
    }

    public String toString() {
        return "GuaranteedThroughputSampler(probabilisticSampler=" + this.probabilisticSampler + ", lowerBoundSampler=" + this.lowerBoundSampler + ", tags=" + this.tags + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GuaranteedThroughputSampler)) {
            return false;
        }
        GuaranteedThroughputSampler other = (GuaranteedThroughputSampler)o;
        ProbabilisticSampler this$probabilisticSampler = this.probabilisticSampler;
        ProbabilisticSampler other$probabilisticSampler = other.probabilisticSampler;
        if (this$probabilisticSampler == null ? other$probabilisticSampler != null : !((Object)this$probabilisticSampler).equals(other$probabilisticSampler)) {
            return false;
        }
        RateLimitingSampler this$lowerBoundSampler = this.lowerBoundSampler;
        RateLimitingSampler other$lowerBoundSampler = other.lowerBoundSampler;
        if (this$lowerBoundSampler == null ? other$lowerBoundSampler != null : !((Object)this$lowerBoundSampler).equals(other$lowerBoundSampler)) {
            return false;
        }
        Map<String, Object> this$tags = this.tags;
        Map<String, Object> other$tags = other.tags;
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ProbabilisticSampler $probabilisticSampler = this.probabilisticSampler;
        result = result * 59 + ($probabilisticSampler == null ? 43 : $probabilisticSampler.hashCode());
        RateLimitingSampler $lowerBoundSampler = this.lowerBoundSampler;
        result = result * 59 + ($lowerBoundSampler == null ? 43 : $lowerBoundSampler.hashCode());
        Map<String, Object> $tags = this.tags;
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    @ConstructorProperties(value={"probabilisticSampler", "lowerBoundSampler", "tags"})
    GuaranteedThroughputSampler(ProbabilisticSampler probabilisticSampler, RateLimitingSampler lowerBoundSampler, Map<String, Object> tags) {
        this.probabilisticSampler = probabilisticSampler;
        this.lowerBoundSampler = lowerBoundSampler;
        this.tags = tags;
    }
}

