/*
 * Decompiled with CFR 0.152.
 */
package io.katharsis.spring;

import io.katharsis.legacy.internal.RepositoryMethodParameterProvider;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.support.AllEncompassingFormHttpMessageConverter;
import org.springframework.http.converter.xml.SourceHttpMessageConverter;
import org.springframework.web.bind.support.ConfigurableWebBindingInitializer;
import org.springframework.web.bind.support.DefaultDataBinderFactory;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.method.annotation.ErrorsMethodArgumentResolver;
import org.springframework.web.method.annotation.ExpressionValueMethodArgumentResolver;
import org.springframework.web.method.annotation.MapMethodProcessor;
import org.springframework.web.method.annotation.ModelMethodProcessor;
import org.springframework.web.method.annotation.RequestHeaderMapMethodArgumentResolver;
import org.springframework.web.method.annotation.RequestHeaderMethodArgumentResolver;
import org.springframework.web.method.annotation.RequestParamMapMethodArgumentResolver;
import org.springframework.web.method.annotation.RequestParamMethodArgumentResolver;
import org.springframework.web.method.annotation.SessionStatusMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodArgumentResolverComposite;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.mvc.method.annotation.HttpEntityMethodProcessor;
import org.springframework.web.servlet.mvc.method.annotation.MatrixVariableMapMethodArgumentResolver;
import org.springframework.web.servlet.mvc.method.annotation.MatrixVariableMethodArgumentResolver;
import org.springframework.web.servlet.mvc.method.annotation.RedirectAttributesMethodArgumentResolver;
import org.springframework.web.servlet.mvc.method.annotation.RequestPartMethodArgumentResolver;
import org.springframework.web.servlet.mvc.method.annotation.RequestResponseBodyMethodProcessor;
import org.springframework.web.servlet.mvc.method.annotation.ServletCookieValueMethodArgumentResolver;
import org.springframework.web.servlet.mvc.method.annotation.ServletModelAttributeMethodProcessor;
import org.springframework.web.servlet.mvc.method.annotation.ServletRequestMethodArgumentResolver;
import org.springframework.web.servlet.mvc.method.annotation.ServletResponseMethodArgumentResolver;
import org.springframework.web.servlet.mvc.method.annotation.UriComponentsBuilderMethodArgumentResolver;

public class SpringParameterProvider
implements RepositoryMethodParameterProvider {
    private HttpServletRequest request;
    private ConfigurableBeanFactory beanFactory;
    private HandlerMethodArgumentResolverComposite argumentResolvers;

    public SpringParameterProvider(ConfigurableBeanFactory beanFactory, HttpServletRequest request) {
        this.request = request;
        this.beanFactory = beanFactory;
        List<HttpMessageConverter<?>> messageConverters = this.getHttpMessageConverters();
        this.argumentResolvers = new HandlerMethodArgumentResolverComposite().addResolvers(this.getArgumentResolvers(messageConverters));
    }

    private List<HttpMessageConverter<?>> getHttpMessageConverters() {
        StringHttpMessageConverter stringHttpMessageConverter = new StringHttpMessageConverter();
        stringHttpMessageConverter.setWriteAcceptCharset(false);
        ArrayList converters = new ArrayList(4);
        converters.add((HttpMessageConverter<?>)new ByteArrayHttpMessageConverter());
        converters.add((HttpMessageConverter<?>)stringHttpMessageConverter);
        converters.add((HttpMessageConverter<?>)new SourceHttpMessageConverter());
        converters.add((HttpMessageConverter<?>)new AllEncompassingFormHttpMessageConverter());
        return converters;
    }

    private List<HandlerMethodArgumentResolver> getArgumentResolvers(List<HttpMessageConverter<?>> messageConverters) {
        LinkedList<HandlerMethodArgumentResolver> resolvers = new LinkedList<HandlerMethodArgumentResolver>();
        resolvers.add((HandlerMethodArgumentResolver)new RequestParamMethodArgumentResolver(this.beanFactory, false));
        resolvers.add((HandlerMethodArgumentResolver)new RequestParamMapMethodArgumentResolver());
        resolvers.add((HandlerMethodArgumentResolver)new MatrixVariableMethodArgumentResolver());
        resolvers.add((HandlerMethodArgumentResolver)new MatrixVariableMapMethodArgumentResolver());
        resolvers.add((HandlerMethodArgumentResolver)new ServletModelAttributeMethodProcessor(false));
        resolvers.add((HandlerMethodArgumentResolver)new RequestResponseBodyMethodProcessor(messageConverters));
        resolvers.add((HandlerMethodArgumentResolver)new RequestPartMethodArgumentResolver(messageConverters));
        resolvers.add((HandlerMethodArgumentResolver)new RequestHeaderMethodArgumentResolver(this.beanFactory));
        resolvers.add((HandlerMethodArgumentResolver)new RequestHeaderMapMethodArgumentResolver());
        resolvers.add((HandlerMethodArgumentResolver)new ServletCookieValueMethodArgumentResolver(this.beanFactory));
        resolvers.add((HandlerMethodArgumentResolver)new ExpressionValueMethodArgumentResolver(this.beanFactory));
        resolvers.add((HandlerMethodArgumentResolver)new ServletRequestMethodArgumentResolver());
        resolvers.add((HandlerMethodArgumentResolver)new ServletResponseMethodArgumentResolver());
        resolvers.add((HandlerMethodArgumentResolver)new HttpEntityMethodProcessor(messageConverters));
        resolvers.add((HandlerMethodArgumentResolver)new RedirectAttributesMethodArgumentResolver());
        resolvers.add((HandlerMethodArgumentResolver)new ModelMethodProcessor());
        resolvers.add((HandlerMethodArgumentResolver)new MapMethodProcessor());
        resolvers.add((HandlerMethodArgumentResolver)new ErrorsMethodArgumentResolver());
        resolvers.add((HandlerMethodArgumentResolver)new SessionStatusMethodArgumentResolver());
        resolvers.add((HandlerMethodArgumentResolver)new UriComponentsBuilderMethodArgumentResolver());
        resolvers.add((HandlerMethodArgumentResolver)new RequestParamMethodArgumentResolver(this.beanFactory, true));
        resolvers.add((HandlerMethodArgumentResolver)new ServletModelAttributeMethodProcessor(true));
        return resolvers;
    }

    public <T> T provide(Method method, int parameterIndex) {
        MethodParameter methodParameter = new MethodParameter(method, parameterIndex);
        ModelAndViewContainer modelAndViewContainer = new ModelAndViewContainer();
        ServletWebRequest webRequest = new ServletWebRequest(this.request);
        DefaultDataBinderFactory binderFactory = new DefaultDataBinderFactory((WebBindingInitializer)new ConfigurableWebBindingInitializer());
        try {
            return (T)this.argumentResolvers.resolveArgument(methodParameter, modelAndViewContainer, (NativeWebRequest)webRequest, (WebDataBinderFactory)binderFactory);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

