/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.websocket;

import io.micronaut.buffer.netty.NettyByteBufferFactory;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.buffer.ByteBufferFactory;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.MutableHeaders;
import io.micronaut.http.MediaType;
import io.micronaut.http.body.MessageBodyHandlerRegistry;
import io.micronaut.http.body.MessageBodyWriter;
import io.micronaut.http.codec.MediaTypeCodec;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.simple.SimpleHttpHeaders;
import io.micronaut.websocket.exceptions.WebSocketSessionException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.nio.ByteBuffer;
import java.util.Optional;

@Requires(classes={WebSocketSessionException.class})
@Singleton
public class WebSocketMessageEncoder {
    private final MediaTypeCodecRegistry codecRegistry;
    @Nullable
    private final MessageBodyHandlerRegistry messageBodyHandlerRegistry;

    @Deprecated(forRemoval=true, since="4.7")
    public WebSocketMessageEncoder(MediaTypeCodecRegistry codecRegistry) {
        this.codecRegistry = codecRegistry;
        this.messageBodyHandlerRegistry = null;
    }

    @Inject
    public WebSocketMessageEncoder(MediaTypeCodecRegistry codecRegistry, MessageBodyHandlerRegistry messageBodyHandlerRegistry) {
        this.codecRegistry = codecRegistry;
        this.messageBodyHandlerRegistry = messageBodyHandlerRegistry;
    }

    public WebSocketFrame encodeMessage(Object message, MediaType mediaType) {
        Argument argument;
        MessageBodyWriter messageBodyWriter;
        if (message instanceof byte[]) {
            byte[] bytes = (byte[])message;
            return new BinaryWebSocketFrame(Unpooled.wrappedBuffer((byte[])bytes));
        }
        if (ClassUtils.isJavaLangType(message.getClass()) || message instanceof CharSequence) {
            String s = message.toString();
            return new TextWebSocketFrame(s);
        }
        if (message instanceof ByteBuf) {
            ByteBuf buf = (ByteBuf)message;
            return new BinaryWebSocketFrame(buf.slice());
        }
        if (message instanceof ByteBuffer) {
            ByteBuffer buffer = (ByteBuffer)message;
            return new BinaryWebSocketFrame(Unpooled.wrappedBuffer((ByteBuffer)buffer));
        }
        MediaType theMediaType = mediaType != null ? mediaType : MediaType.APPLICATION_JSON_TYPE;
        Optional codec = this.codecRegistry.findCodec(theMediaType);
        if (codec.isPresent()) {
            io.micronaut.core.io.buffer.ByteBuffer encoded = ((MediaTypeCodec)codec.get()).encode(message, (ByteBufferFactory)NettyByteBufferFactory.DEFAULT);
            return new TextWebSocketFrame((ByteBuf)encoded.asNativeBuffer());
        }
        if (this.messageBodyHandlerRegistry != null && (messageBodyWriter = (MessageBodyWriter)this.messageBodyHandlerRegistry.findWriter(argument = Argument.ofInstance((Object)message), theMediaType).orElse(null)) != null) {
            io.micronaut.core.io.buffer.ByteBuffer encoded = messageBodyWriter.writeTo(argument, theMediaType, message, (MutableHeaders)new SimpleHttpHeaders(), (ByteBufferFactory)NettyByteBufferFactory.DEFAULT);
            return new TextWebSocketFrame((ByteBuf)encoded.asNativeBuffer());
        }
        throw new WebSocketSessionException("Unable to encode WebSocket message: " + String.valueOf(message));
    }
}

