/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.http.body.CloseableAvailableByteBody;
import io.micronaut.http.body.CloseableByteBody;
import java.io.IOException;
import java.io.InputStream;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.Contract;
import org.reactivestreams.Publisher;

public interface ByteBody {
    @NonNull
    default public CloseableByteBody split() {
        return this.split(SplitBackpressureMode.SLOWEST);
    }

    @NonNull
    public CloseableByteBody split(@NonNull SplitBackpressureMode var1);

    @NonNull
    @Contract(value="-> this")
    default public ByteBody allowDiscard() {
        return this;
    }

    @NonNull
    public OptionalLong expectedLength();

    @NonNull
    public InputStream toInputStream();

    @NonNull
    public Publisher<byte[]> toByteArrayPublisher();

    @NonNull
    public Publisher<ByteBuffer<?>> toByteBufferPublisher();

    public CompletableFuture<? extends CloseableAvailableByteBody> buffer();

    public static enum SplitBackpressureMode {
        SLOWEST,
        FASTEST,
        ORIGINAL,
        NEW;

    }

    public static final class BodyDiscardedException
    extends IOException {
        static final BodyDiscardedException INSTANCE = new BodyDiscardedException();

        BodyDiscardedException() {
        }

        public static BodyDiscardedException create() {
            return INSTANCE;
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

