/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing;

import io.micronaut.annotation.processing.AnnotationProcessingOutputVisitor;
import io.micronaut.annotation.processing.AnnotationUtils;
import io.micronaut.annotation.processing.GenericUtils;
import io.micronaut.annotation.processing.ModelUtils;
import io.micronaut.annotation.processing.visitor.JavaVisitorContext;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.core.convert.value.MutableConvertibleValuesMap;
import io.micronaut.inject.writer.ClassWriterOutputVisitor;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

abstract class AbstractInjectAnnotationProcessor
extends AbstractProcessor {
    protected Messager messager;
    protected Filer filer;
    protected Elements elementUtils;
    protected Types typeUtils;
    protected AnnotationUtils annotationUtils;
    protected GenericUtils genericUtils;
    protected ModelUtils modelUtils;
    protected MutableConvertibleValues<Object> visitorAttributes = new MutableConvertibleValuesMap();
    protected ClassWriterOutputVisitor classWriterOutputVisitor;
    protected JavaVisitorContext javaVisitorContext;

    AbstractInjectAnnotationProcessor() {
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        SourceVersion sourceVersion = SourceVersion.latest();
        if (sourceVersion.ordinal() <= 11) {
            if (sourceVersion.ordinal() >= 8) {
                return sourceVersion;
            }
            return SourceVersion.RELEASE_8;
        }
        return SourceVersion.values()[11];
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.messager = processingEnv.getMessager();
        this.filer = processingEnv.getFiler();
        this.classWriterOutputVisitor = new AnnotationProcessingOutputVisitor(this.filer);
        this.elementUtils = processingEnv.getElementUtils();
        this.typeUtils = processingEnv.getTypeUtils();
        this.modelUtils = new ModelUtils(this.elementUtils, this.typeUtils);
        this.annotationUtils = new AnnotationUtils(processingEnv, this.elementUtils, this.messager, this.typeUtils, this.modelUtils, this.filer, this.visitorAttributes);
        this.genericUtils = new GenericUtils(this.elementUtils, this.typeUtils, this.modelUtils);
        this.javaVisitorContext = new JavaVisitorContext(processingEnv, this.messager, this.elementUtils, this.annotationUtils, this.typeUtils, this.modelUtils, this.filer, this.visitorAttributes);
    }

    protected final void error(Element e, String msg, Object ... args) {
        if (this.messager == null) {
            this.illegalState();
            return;
        }
        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format(msg, args), e);
    }

    protected final void error(String msg, Object ... args) {
        if (this.messager == null) {
            this.illegalState();
        }
        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format(msg, args));
    }

    protected final void warning(Element e, String msg, Object ... args) {
        if (this.messager == null) {
            this.illegalState();
        }
        this.messager.printMessage(Diagnostic.Kind.WARNING, String.format(msg, args), e);
    }

    protected final void warning(String msg, Object ... args) {
        if (this.messager == null) {
            this.illegalState();
        }
        this.messager.printMessage(Diagnostic.Kind.WARNING, String.format(msg, args));
    }

    protected final void note(Element e, String msg, Object ... args) {
        if (this.messager == null) {
            this.illegalState();
        }
        this.messager.printMessage(Diagnostic.Kind.NOTE, String.format(msg, args), e);
    }

    protected final void note(String msg, Object ... args) {
        if (this.messager == null) {
            this.illegalState();
        }
        this.messager.printMessage(Diagnostic.Kind.NOTE, String.format(msg, args));
    }

    private void illegalState() {
        throw new IllegalStateException("No messager set. Ensure processing enviroment is initialized");
    }
}

