/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing;

import io.micronaut.annotation.processing.ModelUtils;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.util.CollectionUtils;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.Parameterizable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

@Internal
public class GenericUtils {
    private final Elements elementUtils;
    private final Types typeUtils;
    private final ModelUtils modelUtils;

    GenericUtils(Elements elementUtils, Types typeUtils, ModelUtils modelUtils) {
        this.elementUtils = elementUtils;
        this.typeUtils = typeUtils;
        this.modelUtils = modelUtils;
    }

    protected TypeMirror interfaceGenericTypeFor(TypeElement element, Class interfaceType) {
        return this.interfaceGenericTypeFor(element, interfaceType.getName());
    }

    protected TypeMirror interfaceGenericTypeFor(TypeElement element, String interfaceName) {
        List<? extends TypeMirror> typeMirrors = this.interfaceGenericTypesFor(element, interfaceName);
        return typeMirrors.isEmpty() ? null : typeMirrors.get(0);
    }

    public List<? extends TypeMirror> interfaceGenericTypesFor(TypeElement element, String interfaceName) {
        for (TypeMirror typeMirror : element.getInterfaces()) {
            TypeElement te;
            DeclaredType declaredType = (DeclaredType)typeMirror;
            Element declaredElement = declaredType.asElement();
            if (!(declaredElement instanceof TypeElement) || !interfaceName.equals((te = (TypeElement)declaredElement).getQualifiedName().toString())) continue;
            return declaredType.getTypeArguments();
        }
        return Collections.emptyList();
    }

    protected Optional<TypeMirror> getFirstTypeArgument(TypeMirror type) {
        DeclaredType declaredType;
        List<? extends TypeMirror> typeArguments;
        TypeMirror typeMirror = null;
        if (type instanceof DeclaredType && CollectionUtils.isNotEmpty(typeArguments = (declaredType = (DeclaredType)type).getTypeArguments())) {
            typeMirror = typeArguments.get(0);
        }
        return Optional.ofNullable(typeMirror);
    }

    protected Map<String, Object> resolveGenericTypes(TypeMirror type, Map<String, Object> boundTypes) {
        TypeVariable var;
        TypeMirror upperBound;
        if (type.getKind().isPrimitive() || type.getKind() == TypeKind.VOID || type.getKind() == TypeKind.ARRAY) {
            return Collections.emptyMap();
        }
        if (type instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)type;
            return this.resolveGenericTypes(declaredType, (TypeElement)declaredType.asElement(), boundTypes);
        }
        if (type instanceof TypeVariable && (upperBound = (var = (TypeVariable)type).getUpperBound()) instanceof DeclaredType) {
            return this.resolveGenericTypes(upperBound, boundTypes);
        }
        return Collections.emptyMap();
    }

    protected Map<String, Object> resolveGenericTypes(DeclaredType type, TypeElement typeElement, Map<String, Object> boundTypes) {
        List<? extends TypeMirror> typeArguments = type.getTypeArguments();
        LinkedHashMap<String, Object> resolvedParameters = new LinkedHashMap<String, Object>();
        List<? extends TypeParameterElement> typeParameters = typeElement.getTypeParameters();
        if (typeArguments.size() == typeParameters.size()) {
            Iterator<? extends TypeMirror> i = typeArguments.iterator();
            for (TypeParameterElement typeParameterElement : typeParameters) {
                String parameterName = typeParameterElement.toString();
                TypeMirror mirror = i.next();
                TypeKind kind = mirror.getKind();
                switch (kind) {
                    case TYPEVAR: {
                        TypeVariable tv = (TypeVariable)mirror;
                        if (boundTypes.containsKey(tv.toString())) {
                            resolvedParameters.put(parameterName, boundTypes.get(tv.toString()));
                            break;
                        }
                        TypeMirror upperBound = tv.getUpperBound();
                        TypeMirror lowerBound = tv.getLowerBound();
                        if (upperBound.getKind() != TypeKind.NULL) {
                            resolvedParameters.put(parameterName, this.resolveTypeReference(upperBound, Collections.emptyMap()));
                            break;
                        }
                        if (lowerBound.getKind() == TypeKind.NULL) break;
                        resolvedParameters.put(parameterName, this.resolveTypeReference(lowerBound, Collections.emptyMap()));
                        break;
                    }
                    case ARRAY: 
                    case BOOLEAN: 
                    case BYTE: 
                    case CHAR: 
                    case DOUBLE: 
                    case FLOAT: 
                    case INT: 
                    case LONG: 
                    case SHORT: {
                        this.resolveGenericTypeParameterForPrimitiveOrArray(resolvedParameters, parameterName, mirror, boundTypes);
                        break;
                    }
                    case DECLARED: {
                        this.resolveGenericTypeParameter(resolvedParameters, parameterName, mirror, boundTypes);
                        break;
                    }
                    case WILDCARD: {
                        WildcardType wcType = (WildcardType)mirror;
                        TypeMirror extendsBound = wcType.getExtendsBound();
                        TypeMirror superBound = wcType.getSuperBound();
                        if (extendsBound != null) {
                            this.resolveGenericTypeParameter(resolvedParameters, parameterName, extendsBound, boundTypes);
                            break;
                        }
                        if (superBound != null) {
                            this.resolveGenericTypeParameter(resolvedParameters, parameterName, superBound, boundTypes);
                            break;
                        }
                        resolvedParameters.put(parameterName, Object.class);
                    }
                }
            }
        }
        return resolvedParameters;
    }

    protected Object resolveTypeReference(TypeMirror mirror) {
        return this.resolveTypeReference(mirror, Collections.emptyMap());
    }

    protected Object resolveTypeReference(TypeMirror mirror, Map<String, Object> boundTypes) {
        TypeKind kind = mirror.getKind();
        switch (kind) {
            case TYPEVAR: {
                TypeVariable tv = (TypeVariable)mirror;
                String name = tv.toString();
                if (boundTypes.containsKey(name)) {
                    return boundTypes.get(name);
                }
                return this.modelUtils.resolveTypeReference(mirror);
            }
            case WILDCARD: {
                WildcardType wcType = (WildcardType)mirror;
                TypeMirror extendsBound = wcType.getExtendsBound();
                TypeMirror superBound = wcType.getSuperBound();
                if (extendsBound == null && superBound == null) {
                    return Object.class.getName();
                }
                if (extendsBound != null) {
                    return this.resolveTypeReference(this.typeUtils.erasure(extendsBound), boundTypes);
                }
                if (superBound != null) {
                    return this.resolveTypeReference(superBound, boundTypes);
                }
                return this.resolveTypeReference(this.typeUtils.getWildcardType(extendsBound, superBound), boundTypes);
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)mirror;
                Object reference = this.resolveTypeReference(arrayType.getComponentType(), boundTypes);
                if (reference instanceof Class) {
                    Class componentType = (Class)reference;
                    return Array.newInstance(componentType, 0).getClass();
                }
                if (reference instanceof String) {
                    return reference + "[]";
                }
                return this.modelUtils.resolveTypeReference(mirror);
            }
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case SHORT: {
                Optional type = ClassUtils.getPrimitiveType((String)mirror.toString());
                if (type.isPresent()) {
                    return type.get();
                }
                throw new IllegalStateException("Unknown primitive type: " + mirror.toString());
            }
        }
        return this.modelUtils.resolveTypeReference(mirror);
    }

    protected DeclaredType resolveTypeVariable(Element element, TypeVariable typeVariable) {
        Element enclosing = element.getEnclosingElement();
        while (enclosing instanceof Parameterizable) {
            Parameterizable parameterizable = (Parameterizable)enclosing;
            String name = typeVariable.toString();
            for (TypeParameterElement typeParameterElement : parameterizable.getTypeParameters()) {
                TypeMirror typeMirror;
                List<? extends TypeMirror> bounds;
                if (!name.equals(typeParameterElement.toString()) || (bounds = typeParameterElement.getBounds()).size() != 1 || (typeMirror = bounds.get(0)).getKind() != TypeKind.DECLARED) continue;
                return (DeclaredType)typeMirror;
            }
            enclosing = enclosing.getEnclosingElement();
        }
        return null;
    }

    protected Map<String, Object> resolveBoundTypes(DeclaredType type) {
        LinkedHashMap<String, Object> boundTypes = new LinkedHashMap<String, Object>(2);
        TypeElement element = (TypeElement)type.asElement();
        List<? extends TypeParameterElement> typeParameters = element.getTypeParameters();
        List<? extends TypeMirror> typeArguments = type.getTypeArguments();
        if (typeArguments.size() == typeParameters.size()) {
            Iterator<? extends TypeMirror> i = typeArguments.iterator();
            for (TypeParameterElement typeParameterElement : typeParameters) {
                boundTypes.put(typeParameterElement.toString(), this.resolveTypeReference(i.next(), boundTypes));
            }
        }
        return boundTypes;
    }

    private void resolveGenericTypeParameter(Map<String, Object> resolvedParameters, String parameterName, TypeMirror mirror, Map<String, Object> boundTypes) {
        TypeVariable tv;
        TypeMirror upperBound;
        if (mirror instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)mirror;
            List<? extends TypeMirror> nestedArguments = declaredType.getTypeArguments();
            if (nestedArguments.isEmpty()) {
                resolvedParameters.put(parameterName, this.resolveTypeReference(this.typeUtils.erasure(mirror), resolvedParameters));
            } else {
                resolvedParameters.put(parameterName, Collections.singletonMap(this.resolveTypeReference(this.typeUtils.erasure(mirror), resolvedParameters), this.resolveGenericTypes(declaredType, boundTypes)));
            }
        } else if (mirror instanceof TypeVariable && (upperBound = (tv = (TypeVariable)mirror).getUpperBound()) instanceof DeclaredType) {
            this.resolveGenericTypeParameter(resolvedParameters, parameterName, upperBound, boundTypes);
        }
    }

    private void resolveGenericTypeParameterForPrimitiveOrArray(Map<String, Object> resolvedParameters, String parameterName, TypeMirror mirror, Map<String, Object> boundTypes) {
        resolvedParameters.put(parameterName, Collections.singletonMap(this.resolveTypeReference(this.typeUtils.erasure(mirror), resolvedParameters), this.resolveGenericTypes(mirror, boundTypes)));
    }
}

