/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.visitor;

import io.micronaut.annotation.processing.visitor.AbstractJavaElement;
import io.micronaut.annotation.processing.visitor.JavaClassElement;
import io.micronaut.annotation.processing.visitor.JavaParameterElement;
import io.micronaut.annotation.processing.visitor.JavaVisitorContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

@Internal
class JavaMethodElement
extends AbstractJavaElement
implements MethodElement {
    private final ExecutableElement executableElement;
    private final JavaVisitorContext visitorContext;

    JavaMethodElement(ExecutableElement executableElement, AnnotationMetadata annotationMetadata, JavaVisitorContext visitorContext) {
        super(executableElement, annotationMetadata, visitorContext);
        this.executableElement = executableElement;
        this.visitorContext = visitorContext;
    }

    public Optional<String> getDocumentation() {
        return Optional.ofNullable(this.visitorContext.getElements().getDocComment(this.executableElement));
    }

    public ClassElement getReturnType() {
        TypeMirror returnType = this.executableElement.getReturnType();
        return this.mirrorToClassElement(returnType, this.visitorContext);
    }

    public ParameterElement[] getParameters() {
        List<? extends VariableElement> parameters = this.executableElement.getParameters();
        return (ParameterElement[])parameters.stream().map(variableElement -> new JavaParameterElement((VariableElement)variableElement, this.visitorContext.getAnnotationUtils().getAnnotationMetadata((Element)variableElement), this.visitorContext)).toArray(ParameterElement[]::new);
    }

    public ClassElement getDeclaringType() {
        Element enclosingElement = this.executableElement.getEnclosingElement();
        if (!(enclosingElement instanceof TypeElement)) {
            throw new IllegalStateException("Enclosing element should be a type element");
        }
        return new JavaClassElement((TypeElement)enclosingElement, this.visitorContext.getAnnotationUtils().getAnnotationMetadata(enclosingElement), this.visitorContext);
    }
}

