/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.visitor;

import io.micronaut.annotation.processing.visitor.AbstractJavaElement;
import io.micronaut.annotation.processing.visitor.JavaClassElement;
import io.micronaut.annotation.processing.visitor.JavaVisitorContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.FieldElement;
import javax.annotation.Nullable;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

@Internal
class JavaFieldElement
extends AbstractJavaElement
implements FieldElement {
    private final JavaVisitorContext visitorContext;
    private final VariableElement variableElement;
    private ClassElement declaringElement;

    JavaFieldElement(VariableElement variableElement, AnnotationMetadata annotationMetadata, JavaVisitorContext visitorContext) {
        super(variableElement, annotationMetadata, visitorContext);
        this.variableElement = variableElement;
        this.visitorContext = visitorContext;
    }

    JavaFieldElement(ClassElement declaringElement, VariableElement variableElement, AnnotationMetadata annotationMetadata, JavaVisitorContext visitorContext) {
        this(variableElement, annotationMetadata, visitorContext);
        this.declaringElement = declaringElement;
    }

    @Nullable
    public ClassElement getType() {
        TypeMirror returnType = this.variableElement.asType();
        return this.mirrorToClassElement(returnType, this.visitorContext);
    }

    public ClassElement getDeclaringType() {
        if (this.declaringElement == null) {
            Element enclosingElement = this.variableElement.getEnclosingElement();
            if (!(enclosingElement instanceof TypeElement)) {
                throw new IllegalStateException("Enclosing element should be a type element");
            }
            this.declaringElement = new JavaClassElement((TypeElement)enclosingElement, this.visitorContext.getAnnotationUtils().getAnnotationMetadata(enclosingElement), this.visitorContext);
        }
        return this.declaringElement;
    }
}

