/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.visitor;

import io.micronaut.annotation.processing.AnnotationUtils;
import io.micronaut.annotation.processing.PublicMethodVisitor;
import io.micronaut.annotation.processing.visitor.AbstractJavaElement;
import io.micronaut.annotation.processing.visitor.JavaConstructorElement;
import io.micronaut.annotation.processing.visitor.JavaFieldElement;
import io.micronaut.annotation.processing.visitor.JavaMethodElement;
import io.micronaut.annotation.processing.visitor.JavaPropertyElement;
import io.micronaut.annotation.processing.visitor.JavaVisitorContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ConstructorElement;
import io.micronaut.inject.ast.ElementModifier;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.processing.JavaModelUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

@Internal
public class JavaClassElement
extends AbstractJavaElement
implements ClassElement {
    private final TypeElement classElement;
    private final JavaVisitorContext visitorContext;
    private Map<String, Map<String, TypeMirror>> genericTypeInfo;

    protected JavaClassElement(TypeElement classElement, AnnotationMetadata annotationMetadata, JavaVisitorContext visitorContext) {
        super(classElement, annotationMetadata, visitorContext);
        this.classElement = classElement;
        this.visitorContext = visitorContext;
    }

    JavaClassElement(TypeElement classElement, AnnotationMetadata annotationMetadata, JavaVisitorContext visitorContext, Map<String, Map<String, TypeMirror>> genericsInfo) {
        super(classElement, annotationMetadata, visitorContext);
        this.classElement = classElement;
        this.visitorContext = visitorContext;
        this.genericTypeInfo = genericsInfo;
    }

    @Nonnull
    public Map<String, ClassElement> getTypeArguments(@Nonnull String type) {
        Map<String, Map<String, Object>> data;
        Map<String, Object> forType;
        if (StringUtils.isNotEmpty((CharSequence)type) && (forType = (data = this.visitorContext.getGenericUtils().buildGenericTypeArgumentInfo(this.classElement)).get(type)) != null) {
            LinkedHashMap<String, ClassElement> typeArgs = new LinkedHashMap<String, ClassElement>(forType.size());
            for (Map.Entry<String, Object> entry : forType.entrySet()) {
                ClassElement ce;
                Object v = entry.getValue();
                ClassElement classElement = ce = v != null ? (ClassElement)this.visitorContext.getClassElement(v.toString()).orElse(null) : null;
                if (ce == null) {
                    return Collections.emptyMap();
                }
                typeArgs.put(entry.getKey(), ce);
            }
            return Collections.unmodifiableMap(typeArgs);
        }
        return Collections.emptyMap();
    }

    public boolean isPrimitive() {
        return ClassUtils.getPrimitiveType((String)this.getName()).isPresent();
    }

    public Optional<ClassElement> getSuperType() {
        Element element;
        TypeMirror superclass = this.classElement.getSuperclass();
        if (superclass != null && (element = this.visitorContext.getTypes().asElement(superclass)) instanceof TypeElement) {
            TypeElement superElement = (TypeElement)element;
            if (!Object.class.getName().equals(superElement.getQualifiedName().toString())) {
                return Optional.of(new JavaClassElement(superElement, this.visitorContext.getAnnotationUtils().getAnnotationMetadata(superElement), this.visitorContext));
            }
        }
        return Optional.empty();
    }

    @Override
    public boolean isAbstract() {
        return this.classElement.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    public boolean isInterface() {
        return JavaModelUtils.isInterface((Element)this.classElement);
    }

    public List<PropertyElement> getBeanProperties() {
        final LinkedHashMap props = new LinkedHashMap();
        final LinkedHashMap fields = new LinkedHashMap();
        this.classElement.asType().accept(new PublicMethodVisitor<Object, Object>(this.visitorContext.getTypes()){

            @Override
            protected boolean isAcceptable(Element element) {
                Set<Modifier> modifiers;
                if (element.getKind() == ElementKind.FIELD) {
                    return true;
                }
                if (element.getKind() == ElementKind.METHOD && element instanceof ExecutableElement && (modifiers = element.getModifiers()).contains((Object)Modifier.PUBLIC) && !modifiers.contains((Object)Modifier.STATIC) && !modifiers.contains((Object)Modifier.ABSTRACT)) {
                    ExecutableElement executableElement = (ExecutableElement)element;
                    String methodName = executableElement.getSimpleName().toString();
                    if (methodName.contains("$")) {
                        return false;
                    }
                    if (NameUtils.isGetterName((String)methodName) && executableElement.getParameters().size() == 0) {
                        return true;
                    }
                    return NameUtils.isSetterName((String)methodName) && executableElement.getParameters().size() == 1;
                }
                return false;
            }

            @Override
            protected void accept(DeclaredType declaringType, Element element, Object o) {
                if (element instanceof VariableElement) {
                    fields.put(element.getSimpleName().toString(), (VariableElement)element);
                    return;
                }
                ExecutableElement executableElement = (ExecutableElement)element;
                String methodName = executableElement.getSimpleName().toString();
                TypeElement declaringTypeElement = (TypeElement)executableElement.getEnclosingElement();
                if (NameUtils.isGetterName((String)methodName) && executableElement.getParameters().size() == 0) {
                    ClassElement getterReturnType;
                    String propertyName = NameUtils.getPropertyNameForGetter((String)methodName);
                    TypeMirror returnType = executableElement.getReturnType();
                    if (returnType instanceof TypeVariable) {
                        TypeVariable tv = (TypeVariable)returnType;
                        String tvn = tv.toString();
                        ClassElement classElement = JavaClassElement.this.getTypeArguments().get(tvn);
                        getterReturnType = classElement != null ? classElement : JavaClassElement.this.mirrorToClassElement(returnType, JavaClassElement.this.visitorContext, JavaClassElement.this.genericTypeInfo);
                    } else {
                        getterReturnType = JavaClassElement.this.mirrorToClassElement(returnType, JavaClassElement.this.visitorContext, JavaClassElement.this.genericTypeInfo);
                    }
                    if (getterReturnType != null) {
                        TypeMirror typeMirror;
                        ClassElement setterParameterType;
                        BeanPropertyData beanPropertyData = props.computeIfAbsent(propertyName, x$0 -> new BeanPropertyData((String)x$0));
                        this.configureDeclaringType(declaringTypeElement, beanPropertyData);
                        beanPropertyData.type = getterReturnType;
                        beanPropertyData.getter = executableElement;
                        if (!(beanPropertyData.setter == null || (setterParameterType = JavaClassElement.this.mirrorToClassElement(typeMirror = beanPropertyData.setter.getParameters().get(0).asType(), JavaClassElement.this.visitorContext, JavaClassElement.this.genericTypeInfo)) != null && setterParameterType.getName().equals(getterReturnType.getName()))) {
                            beanPropertyData.setter = null;
                        }
                    }
                } else if (NameUtils.isSetterName((String)methodName) && executableElement.getParameters().size() == 1) {
                    String propertyName = NameUtils.getPropertyNameForSetter((String)methodName);
                    TypeMirror typeMirror = executableElement.getParameters().get(0).asType();
                    ClassElement setterParameterType = JavaClassElement.this.mirrorToClassElement(typeMirror, JavaClassElement.this.visitorContext, JavaClassElement.this.genericTypeInfo);
                    if (setterParameterType != null) {
                        BeanPropertyData beanPropertyData = props.computeIfAbsent(propertyName, x$0 -> new BeanPropertyData((String)x$0));
                        this.configureDeclaringType(declaringTypeElement, beanPropertyData);
                        ClassElement propertyType = beanPropertyData.type;
                        if (propertyType != null) {
                            if (propertyType.getName().equals(setterParameterType.getName())) {
                                beanPropertyData.setter = executableElement;
                            }
                        } else {
                            beanPropertyData.setter = executableElement;
                        }
                    }
                }
            }

            private void configureDeclaringType(TypeElement declaringTypeElement, BeanPropertyData beanPropertyData) {
                if (beanPropertyData.declaringType == null && !JavaClassElement.this.classElement.equals(declaringTypeElement)) {
                    beanPropertyData.declaringType = JavaClassElement.this.mirrorToClassElement(declaringTypeElement.asType(), JavaClassElement.this.visitorContext, JavaClassElement.this.genericTypeInfo);
                }
            }
        }, null);
        if (!props.isEmpty()) {
            ArrayList<2> propertyElements = new ArrayList<2>();
            for (Map.Entry entry : props.entrySet()) {
                String propertyName = (String)entry.getKey();
                final BeanPropertyData value = (BeanPropertyData)entry.getValue();
                VariableElement fieldElement = (VariableElement)fields.get(propertyName);
                if (value.getter == null) continue;
                final AnnotationMetadata annotationMetadata = fieldElement != null ? this.visitorContext.getAnnotationUtils().getAnnotationMetadata(fieldElement, value.getter) : this.visitorContext.getAnnotationUtils().newAnnotationBuilder().buildForMethod(value.getter);
                JavaPropertyElement propertyElement = new JavaPropertyElement(value.declaringType == null ? this : value.declaringType, value.getter, annotationMetadata, propertyName, value.type, value.setter == null, this.visitorContext){

                    public Optional<String> getDocumentation() {
                        Elements elements = JavaClassElement.this.visitorContext.getElements();
                        String docComment = elements.getDocComment(value.getter);
                        return Optional.ofNullable(docComment);
                    }

                    public Optional<MethodElement> getWriteMethod() {
                        if (value.setter != null) {
                            return Optional.of(new JavaMethodElement(JavaClassElement.this, value.setter, JavaClassElement.this.visitorContext.getAnnotationUtils().newAnnotationBuilder().buildForMethod(value.setter), JavaClassElement.this.visitorContext));
                        }
                        return Optional.empty();
                    }

                    public Optional<MethodElement> getReadMethod() {
                        return Optional.of(new JavaMethodElement(JavaClassElement.this, value.getter, annotationMetadata, JavaClassElement.this.visitorContext));
                    }
                };
                propertyElements.add(propertyElement);
            }
            return Collections.unmodifiableList(propertyElements);
        }
        return Collections.emptyList();
    }

    public List<FieldElement> getFields(final @Nonnull Predicate<Set<ElementModifier>> modifierFilter) {
        final ArrayList fields = new ArrayList();
        this.classElement.asType().accept(new PublicMethodVisitor<Object, Object>(this.visitorContext.getTypes()){

            @Override
            protected boolean isAcceptable(Element element) {
                Set mods = element.getModifiers().stream().map(m -> ElementModifier.valueOf((String)m.name())).collect(Collectors.toSet());
                return element.getKind() == ElementKind.FIELD && element instanceof VariableElement && modifierFilter.test(mods);
            }

            @Override
            protected void accept(DeclaredType type, Element element, Object o) {
                AnnotationMetadata fieldMetadata = JavaClassElement.this.visitorContext.getAnnotationUtils().getAnnotationMetadata(element);
                fields.add(new JavaFieldElement(JavaClassElement.this, (VariableElement)element, fieldMetadata, JavaClassElement.this.visitorContext));
            }
        }, null);
        return Collections.unmodifiableList(fields);
    }

    public boolean isArray() {
        return this.classElement.asType().getKind() == TypeKind.ARRAY;
    }

    @Override
    public String getName() {
        return JavaModelUtils.getClassName((TypeElement)this.classElement);
    }

    public boolean isAssignable(String type) {
        TypeElement otherElement = this.visitorContext.getElements().getTypeElement(type);
        if (otherElement != null) {
            Types types = this.visitorContext.getTypes();
            TypeMirror thisType = types.erasure(this.classElement.asType());
            TypeMirror thatType = types.erasure(otherElement.asType());
            return types.isAssignable(thisType, thatType);
        }
        return false;
    }

    @Override
    public AnnotationMetadata getAnnotationMetadata() {
        return super.getAnnotationMetadata();
    }

    @Nonnull
    public Optional<ConstructorElement> getPrimaryConstructor() {
        AnnotationUtils annotationUtils = this.visitorContext.getAnnotationUtils();
        return Optional.ofNullable(this.visitorContext.getModelUtils().concreteConstructorFor(this.classElement, annotationUtils)).map(executableElement -> {
            AnnotationMetadata annotationMetadata = annotationUtils.getAnnotationMetadata((Element)executableElement);
            return new JavaConstructorElement(this, (ExecutableElement)executableElement, annotationMetadata, this.visitorContext);
        });
    }

    public boolean hasDefaultConstructor() {
        return this.visitorContext.getModelUtils().hasDefaultConstructor(this.classElement);
    }

    @Nonnull
    public Map<String, ClassElement> getTypeArguments() {
        List<? extends TypeParameterElement> typeParameters = this.classElement.getTypeParameters();
        Iterator<? extends TypeParameterElement> tpi = typeParameters.iterator();
        LinkedHashMap<String, ClassElement> map = new LinkedHashMap<String, ClassElement>();
        while (tpi.hasNext()) {
            TypeParameterElement tpe = tpi.next();
            ClassElement classElement = this.mirrorToClassElement(tpe.asType(), this.visitorContext, this.genericTypeInfo);
            if (classElement == null) continue;
            map.put(tpe.toString(), classElement);
        }
        return Collections.unmodifiableMap(map);
    }

    Map<String, Map<String, TypeMirror>> getGenericTypeInfo() {
        if (this.genericTypeInfo == null) {
            this.genericTypeInfo = this.visitorContext.getGenericUtils().buildGenericTypeArgumentElementInfo(this.classElement);
        }
        return this.genericTypeInfo;
    }

    private class BeanPropertyData {
        ClassElement type;
        ClassElement declaringType;
        ExecutableElement getter;
        ExecutableElement setter;
        final String propertyName;

        public BeanPropertyData(String propertyName) {
            this.propertyName = propertyName;
        }
    }
}

