/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing;

import io.micronaut.inject.writer.AbstractClassWriterOutputVisitor;
import io.micronaut.inject.writer.ClassGenerationException;
import io.micronaut.inject.writer.GeneratedFile;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public class AnnotationProcessingOutputVisitor
extends AbstractClassWriterOutputVisitor {
    private final Filer filer;
    private final Map<String, Optional<GeneratedFile>> metaInfFiles = new HashMap<String, Optional<GeneratedFile>>();
    private final Map<String, FileObject> openedFiles = new HashMap<String, FileObject>();
    private final Map<String, Optional<GeneratedFile>> generatedFiles = new HashMap<String, Optional<GeneratedFile>>();

    public AnnotationProcessingOutputVisitor(Filer filer) {
        this.filer = filer;
    }

    public OutputStream visitClass(String classname) throws IOException {
        JavaFileObject javaFileObject = this.filer.createClassFile(classname, new Element[0]);
        return javaFileObject.openOutputStream();
    }

    public Optional<GeneratedFile> visitMetaInfFile(String path) {
        return this.metaInfFiles.computeIfAbsent(path, s -> {
            String finalPath = "META-INF/" + path;
            return Optional.of(new GeneratedFileObject(finalPath));
        });
    }

    public Optional<GeneratedFile> visitGeneratedFile(String path) {
        return this.generatedFiles.computeIfAbsent(path, s -> Optional.of(new GeneratedFileObject(path, StandardLocation.SOURCE_OUTPUT)));
    }

    private FileObject openFileForReading(String path) {
        return this.openedFiles.computeIfAbsent(path, s -> {
            try {
                return this.filer.getResource(StandardLocation.CLASS_OUTPUT, "", path);
            }
            catch (IOException e) {
                throw new ClassGenerationException("Unable to open file for path: " + path, (Throwable)e);
            }
        });
    }

    class GeneratedFileObject
    implements GeneratedFile {
        private final String path;
        private final StandardLocation classOutput;
        private FileObject inputObject;
        private FileObject outputObject;

        GeneratedFileObject(String path) {
            this.path = path;
            this.classOutput = StandardLocation.CLASS_OUTPUT;
        }

        GeneratedFileObject(String path, StandardLocation location) {
            this.path = path;
            this.classOutput = location;
        }

        public URI toURI() {
            try {
                return this.getOutputObject().toUri();
            }
            catch (IOException e) {
                throw new ClassGenerationException("Unable to return URI for file object: " + this.path);
            }
        }

        public String getName() {
            return this.path;
        }

        public Writer openWriter() throws IOException {
            return this.getOutputObject().openWriter();
        }

        public OutputStream openOutputStream() throws IOException {
            return this.getOutputObject().openOutputStream();
        }

        public InputStream openInputStream() throws IOException {
            if (this.inputObject == null) {
                this.inputObject = AnnotationProcessingOutputVisitor.this.openFileForReading(this.path);
            }
            return this.inputObject.openInputStream();
        }

        public Reader openReader() throws IOException {
            if (this.inputObject == null) {
                this.inputObject = AnnotationProcessingOutputVisitor.this.openFileForReading(this.path);
            }
            return this.inputObject.openReader(true);
        }

        public CharSequence getTextContent() throws IOException {
            try {
                if (this.inputObject == null) {
                    this.inputObject = AnnotationProcessingOutputVisitor.this.openFileForReading(this.path);
                }
                return this.inputObject.getCharContent(true);
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }

        private FileObject getOutputObject() throws IOException {
            if (this.outputObject == null) {
                this.outputObject = AnnotationProcessingOutputVisitor.this.filer.createResource(this.classOutput, "", this.path, new Element[0]);
            }
            return this.outputObject;
        }
    }
}

