/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jackson.core.tree;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.jackson.core.tree.JsonStreamTransfer;
import io.micronaut.json.JsonStreamConfig;
import io.micronaut.json.tree.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class TreeGenerator
extends JsonGenerator {
    private ObjectCodec codec;
    private int generatorFeatures;
    private final Deque<StructureBuilder> structureStack = new ArrayDeque<StructureBuilder>();
    private JsonNode completed = null;

    TreeGenerator() {
    }

    public JsonGenerator setCodec(ObjectCodec oc) {
        this.codec = oc;
        return this;
    }

    public ObjectCodec getCodec() {
        return this.codec;
    }

    public Version version() {
        return Version.unknownVersion();
    }

    public JsonStreamContext getOutputContext() {
        return null;
    }

    public JsonGenerator enable(JsonGenerator.Feature f) {
        this.generatorFeatures |= f.getMask();
        return this;
    }

    public JsonGenerator disable(JsonGenerator.Feature f) {
        this.generatorFeatures &= ~f.getMask();
        return this;
    }

    public boolean isEnabled(JsonGenerator.Feature f) {
        return (this.generatorFeatures & f.getMask()) != 0;
    }

    public int getFeatureMask() {
        return this.generatorFeatures;
    }

    public JsonGenerator setFeatureMask(int values) {
        this.generatorFeatures = values;
        return this;
    }

    public JsonGenerator useDefaultPrettyPrinter() {
        return this;
    }

    private void checkEmptyNodeStack(JsonToken token) throws JsonGenerationException {
        if (this.structureStack.isEmpty()) {
            throw new JsonGenerationException("Unexpected " + TreeGenerator.tokenType(token) + " literal", (JsonGenerator)this);
        }
    }

    private static String tokenType(JsonToken token) {
        return switch (token) {
            case JsonToken.END_OBJECT, JsonToken.END_ARRAY -> "container end";
            case JsonToken.FIELD_NAME -> "field";
            case JsonToken.VALUE_NUMBER_INT -> "integer";
            case JsonToken.VALUE_STRING -> "string";
            case JsonToken.VALUE_NUMBER_FLOAT -> "float";
            case JsonToken.VALUE_NULL -> "null";
            case JsonToken.VALUE_TRUE, JsonToken.VALUE_FALSE -> "boolean";
            default -> "";
        };
    }

    private void complete(JsonNode value) throws JsonGenerationException {
        if (this.completed != null) {
            throw new JsonGenerationException("Tree generator has already completed", (JsonGenerator)this);
        }
        this.completed = value;
    }

    public boolean isComplete() {
        return this.completed != null;
    }

    @NonNull
    public JsonNode getCompletedValue() {
        if (!this.isComplete()) {
            throw new IllegalStateException("Not completed");
        }
        return this.completed;
    }

    public void writeStartArray() {
        this.structureStack.push(new ArrayBuilder());
    }

    private void writeEndStructure(JsonToken token) throws JsonGenerationException {
        this.checkEmptyNodeStack(token);
        StructureBuilder current = this.structureStack.pop();
        if (this.structureStack.isEmpty()) {
            this.complete(current.build());
        } else {
            this.structureStack.peekFirst().addValue(current.build());
        }
    }

    public void writeEndArray() throws IOException {
        this.writeEndStructure(JsonToken.END_ARRAY);
    }

    public void writeStartObject() {
        this.structureStack.push(new ObjectBuilder());
    }

    public void writeEndObject() throws IOException {
        this.writeEndStructure(JsonToken.END_OBJECT);
    }

    public void writeFieldName(String name) throws IOException {
        this.checkEmptyNodeStack(JsonToken.FIELD_NAME);
        this.structureStack.peekFirst().setCurrentFieldName(name);
    }

    public void writeFieldName(SerializableString name) throws IOException {
        this.writeFieldName(name.getValue());
    }

    private void writeScalar(JsonToken token, JsonNode value) throws JsonGenerationException {
        if (this.structureStack.isEmpty()) {
            this.complete(value);
        } else {
            this.structureStack.peekFirst().addValue(value);
        }
    }

    public void writeString(String text) throws IOException {
        this.writeScalar(JsonToken.VALUE_STRING, JsonNode.createStringNode((String)text));
    }

    public void writeString(char[] buffer, int offset, int len) throws IOException {
        this.writeString(new String(buffer, offset, len));
    }

    public void writeString(SerializableString text) throws IOException {
        this.writeString(text.getValue());
    }

    public void writeRawUTF8String(byte[] buffer, int offset, int len) {
        this._reportUnsupportedOperation();
    }

    public void writeUTF8String(byte[] buffer, int offset, int len) {
        this._reportUnsupportedOperation();
    }

    public void writeRaw(String text) {
        this._reportUnsupportedOperation();
    }

    public void writeRaw(String text, int offset, int len) {
        this._reportUnsupportedOperation();
    }

    public void writeRaw(char[] text, int offset, int len) {
        this._reportUnsupportedOperation();
    }

    public void writeRaw(char c) {
        this._reportUnsupportedOperation();
    }

    public void writeRawValue(String text) throws IOException {
        this.writeObject(text);
    }

    public void writeRawValue(String text, int offset, int len) throws IOException {
        this.writeRawValue(text.substring(offset, len));
    }

    public void writeRawValue(char[] text, int offset, int len) throws IOException {
        this.writeRawValue(new String(text, offset, len));
    }

    public void writeBinary(Base64Variant bv, byte[] data, int offset, int len) {
        this._reportUnsupportedOperation();
    }

    public int writeBinary(Base64Variant bv, InputStream data, int dataLength) {
        this._reportUnsupportedOperation();
        return 0;
    }

    public void writeNumber(int v) throws IOException {
        this.writeScalar(JsonToken.VALUE_NUMBER_INT, JsonNode.createNumberNode((int)v));
    }

    public void writeNumber(long v) throws IOException {
        this.writeScalar(JsonToken.VALUE_NUMBER_INT, JsonNode.createNumberNode((long)v));
    }

    public void writeNumber(BigInteger v) throws IOException {
        this.writeScalar(JsonToken.VALUE_NUMBER_INT, JsonNode.createNumberNode((BigInteger)v));
    }

    public void writeNumber(double v) throws IOException {
        this.writeScalar(JsonToken.VALUE_NUMBER_FLOAT, JsonNode.createNumberNode((double)v));
    }

    public void writeNumber(float v) throws IOException {
        this.writeScalar(JsonToken.VALUE_NUMBER_FLOAT, JsonNode.createNumberNode((float)v));
    }

    public void writeNumber(BigDecimal v) throws IOException {
        this.writeScalar(JsonToken.VALUE_NUMBER_FLOAT, JsonNode.createNumberNode((BigDecimal)v));
    }

    public void writeNumber(String encodedValue) {
        this._reportUnsupportedOperation();
    }

    public void writeBoolean(boolean state) throws IOException {
        this.writeScalar(state ? JsonToken.VALUE_TRUE : JsonToken.VALUE_FALSE, JsonNode.createBooleanNode((boolean)state));
    }

    public void writeNull() throws IOException {
        this.writeScalar(JsonToken.VALUE_NULL, JsonNode.nullNode());
    }

    public void writeObject(Object pojo) throws IOException {
        this.getCodec().writeValue((JsonGenerator)this, pojo);
    }

    public void writeTree(TreeNode rootNode) throws IOException {
        if (rootNode == null) {
            this.writeNull();
        } else if (rootNode instanceof JsonNode) {
            JsonNode node = (JsonNode)rootNode;
            this.writeScalar(JsonToken.VALUE_EMBEDDED_OBJECT, node);
        } else {
            JsonStreamTransfer.transferNext(rootNode.traverse(), this, JsonStreamConfig.DEFAULT);
        }
    }

    public void flush() throws IOException {
    }

    public boolean isClosed() {
        return false;
    }

    public void close() throws IOException {
    }

    private class ArrayBuilder
    implements StructureBuilder {
        final List<JsonNode> values = new ArrayList<JsonNode>();

        private ArrayBuilder() {
        }

        @Override
        public void addValue(JsonNode value) {
            this.values.add(value);
        }

        @Override
        public void setCurrentFieldName(String currentFieldName) throws JsonGenerationException {
            throw new JsonGenerationException("Expected array value, got field name", (JsonGenerator)TreeGenerator.this);
        }

        @Override
        public JsonNode build() {
            return JsonNode.createArrayNode(this.values);
        }
    }

    private static interface StructureBuilder {
        public void addValue(JsonNode var1) throws JsonGenerationException;

        public void setCurrentFieldName(String var1) throws JsonGenerationException;

        public JsonNode build();
    }

    private class ObjectBuilder
    implements StructureBuilder {
        final Map<String, JsonNode> values = new LinkedHashMap<String, JsonNode>();
        String currentFieldName = null;

        private ObjectBuilder() {
        }

        @Override
        public void addValue(JsonNode value) throws JsonGenerationException {
            if (this.currentFieldName == null) {
                throw new JsonGenerationException("Expected field name, got value", (JsonGenerator)TreeGenerator.this);
            }
            this.values.put(this.currentFieldName, value);
            this.currentFieldName = null;
        }

        @Override
        public void setCurrentFieldName(String currentFieldName) {
            this.currentFieldName = currentFieldName;
        }

        @Override
        public JsonNode build() {
            return JsonNode.createObjectNode(this.values);
        }
    }
}

