/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers;

import io.micronaut.context.annotation.DefaultImplementation;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.config.annotation.SerdeConfig;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.deserializers.DeserBean;
import io.micronaut.serde.support.deserializers.DeserBeanRegistry;
import io.micronaut.serde.support.util.SubtypeInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

@Internal
record DeserializeSubtypeInfo<T>(@NonNull Map<String, DeserBean<? extends T>> subtypes, SubtypeInfo info, String defaultDiscriminator) {
    @Nullable
    static <T> DeserializeSubtypeInfo<T> create(@Nullable SubtypeInfo subtypeInfo, BeanIntrospection<T> introspection, Deserializer.DecoderContext decoderContext, DeserBeanRegistry deserBeanRegistry) throws SerdeException {
        if (subtypeInfo == null) {
            return null;
        }
        Class superType = introspection.getBeanType();
        Collection subtypeIntrospections = decoderContext.getDeserializableSubtypes(superType);
        HashMap subtypes = CollectionUtils.newHashMap((int)subtypeIntrospections.size());
        Class defaultType = introspection.classValue(DefaultImplementation.class).orElse(null);
        String defaultDiscriminator = null;
        for (BeanIntrospection subtypeIntrospection : subtypeIntrospections) {
            String[] names;
            Class subBeanType = subtypeIntrospection.getBeanType();
            DeserBean deserBean = deserBeanRegistry.getDeserializableBean(Argument.of((Class)subBeanType), decoderContext);
            String[] types = subtypeInfo.subtypes().get(subBeanType);
            if (types != null) {
                for (String type : types) {
                    subtypes.put(type, deserBean);
                }
            }
            if (defaultType != null && defaultType.equals(subBeanType)) {
                defaultDiscriminator = (String)subtypeIntrospection.stringValue(SerdeConfig.class, "typeName").orElseThrow();
            }
            subtypeIntrospection.stringValue(SerdeConfig.class, "typeName").ifPresent(name -> subtypes.put(name, deserBean));
            for (String name2 : names = subtypeIntrospection.stringValues(SerdeConfig.class, "typeNames")) {
                subtypes.put(name2, deserBean);
            }
        }
        return new DeserializeSubtypeInfo<T>(subtypes, subtypeInfo, defaultDiscriminator);
    }
}

