/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.deserializers.collect;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.DeserializerRegistrar;
import io.micronaut.serde.util.CustomizableDeserializer;
import java.util.Collection;

@Internal
abstract class SpecificOnlyCollectionDeserializer<E, C extends Collection<E>>
implements CustomizableDeserializer<C>,
DeserializerRegistrar<C> {
    private final Class<? extends Collection> type;

    SpecificOnlyCollectionDeserializer(Class<? extends Collection> type) {
        this.type = type;
    }

    public Deserializer<C> createSpecific(Deserializer.DecoderContext context, Argument<? super C> type) throws SerdeException {
        Object[] generics = type.getTypeParameters();
        if (ArrayUtils.isEmpty((Object[])generics)) {
            throw new SerdeException("Cannot deserialize raw list");
        }
        Object collectionItemArgument = generics[0];
        Deserializer valueDeser = context.findDeserializer((Argument)collectionItemArgument).createSpecific(context, (Argument)collectionItemArgument);
        return this.createSpecific(type, (Argument<E>)collectionItemArgument, (Deserializer<? extends E>)valueDeser);
    }

    protected abstract Deserializer<C> createSpecific(Argument<? super C> var1, Argument<E> var2, Deserializer<? extends E> var3);

    @Override
    public Argument<C> getType() {
        return Argument.of(this.type, (Argument[])new Argument[]{Argument.ofTypeVariable(Object.class, (String)"E")});
    }
}

