/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.serde.support.serdes;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.config.SerdeConfiguration;
import io.micronaut.serde.exceptions.SerdeException;
import io.micronaut.serde.support.SerdeRegistrar;
import io.micronaut.serde.util.BinaryCodecUtil;
import java.io.IOException;

@Internal
final class ByteArraySerde
implements SerdeRegistrar<byte[]> {
    private final boolean writeLegacyByteArrays;

    public ByteArraySerde(SerdeConfiguration serdeConfiguration) {
        this(serdeConfiguration.isWriteBinaryAsArray());
    }

    public ByteArraySerde(boolean writeLegacyByteArrays) {
        this.writeLegacyByteArrays = writeLegacyByteArrays;
    }

    @NonNull
    public Serializer<byte[]> createSpecific(@NonNull Serializer.EncoderContext context, @NonNull Argument<? extends byte[]> type) throws SerdeException {
        return context.getSerdeConfiguration().map(ByteArraySerde::new).orElse(this);
    }

    @NonNull
    public Deserializer<byte[]> createSpecific(@NonNull Deserializer.DecoderContext context, @NonNull Argument<? super byte[]> type) throws SerdeException {
        return context.getSerdeConfiguration().map(ByteArraySerde::new).orElse(this);
    }

    public byte[] deserialize(Decoder decoder, Deserializer.DecoderContext decoderContext, Argument<? super byte[]> type) throws IOException {
        return decoder.decodeBinary();
    }

    public byte[] deserializeNullable(@NonNull Decoder decoder, @NonNull Deserializer.DecoderContext context, @NonNull Argument<? super byte[]> type) throws IOException {
        return decoder.decodeBinaryNullable();
    }

    public void serialize(Encoder encoder, Serializer.EncoderContext context, Argument<? extends byte[]> type, byte[] value) throws IOException {
        if (this.writeLegacyByteArrays) {
            BinaryCodecUtil.encodeToArray((Encoder)encoder, (byte[])value);
        } else {
            encoder.encodeBinary(value);
        }
    }

    public boolean isEmpty(Serializer.EncoderContext context, byte[] value) {
        return value == null || value.length == 0;
    }

    @Override
    public Argument<byte[]> getType() {
        return Argument.of(byte[].class);
    }
}

