/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.jetty;

import com.nitorcreations.core.utils.KillProcess;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dropwizard.metrics.servlets.AdminServlet;
import io.nflow.jetty.JettyServerContainer;
import io.nflow.jetty.config.NflowJettyConfiguration;
import io.nflow.jetty.servlet.MetricsServletContextListener;
import io.nflow.jetty.spring.NflowAnnotationConfigWebApplicationContext;
import io.nflow.server.spring.NflowStandardEnvironment;
import jakarta.servlet.Servlet;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.cxf.transport.servlet.CXFServlet;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.CustomRequestLog;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.RequestLogWriter;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.joda.time.DateTimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;

@SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD", "UUF_UNUSED_FIELD"}, justification="FindBugs bug")
public class StartNflow {
    private static final Logger logger = LoggerFactory.getLogger(StartNflow.class);
    private final Set<Class<?>> annotatedContextClasses = new LinkedHashSet();

    public static void main(String ... args) throws Exception {
        new StartNflow().startJetty(Collections.emptyMap());
    }

    public StartNflow registerSpringContext(Class<?> ... springContextClass) {
        this.annotatedContextClasses.addAll(Arrays.asList(springContextClass));
        return this;
    }

    public JettyServerContainer startJetty(int port, String env, String profiles) throws Exception {
        return this.startJetty(port, env, profiles, new LinkedHashMap<String, Object>());
    }

    public JettyServerContainer startJetty(int port, String env, String profiles, Map<String, Object> properties) throws Exception {
        properties.put("port", port);
        properties.put("env", env);
        properties.put("profiles", profiles);
        return this.startJetty(properties);
    }

    public JettyServerContainer startJetty(Map<String, Object> properties) throws Exception {
        long start = DateTimeUtils.currentTimeMillis();
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        NflowStandardEnvironment env = new NflowStandardEnvironment(properties);
        String host = env.getRequiredProperty("host");
        int port = (Integer)env.getRequiredProperty("port", Integer.class);
        KillProcess.gracefullyTerminateOrKillProcessUsingPort((int)port, (int)((Integer)env.getRequiredProperty("terminate.timeout", Integer.class)), (boolean)true);
        Server server = this.setupServer();
        this.setupJmx((Container)server, (Environment)env);
        this.setupServerConnector(server, host, port);
        ServletContextHandler context = this.setupServletContextHandler((String[])env.getRequiredProperty("extra.resource.directories", String[].class));
        this.setupHandlers((HandlerWrapper)server, (Handler)context, (PropertyResolver)env);
        this.setupSpring(context, (ConfigurableEnvironment)env);
        this.setupCxf(context);
        this.setupMetricsAdminServlet(context);
        server.start();
        long end = DateTimeUtils.currentTimeMillis();
        JettyServerContainer startedServer = new JettyServerContainer(server);
        port = startedServer.getPort();
        logger.info("Successfully started Jetty on port {} in {} seconds in environment {}", new Object[]{port, (double)(end - start) / 1000.0, Arrays.toString(env.getActiveProfiles())});
        logger.info("API available at http://{}:{}{}", new Object[]{host, port, "/nflow/api"});
        logger.info("Swagger available at http://{}:{}/nflow/ui/doc/", (Object)host, (Object)port);
        logger.info("Explorer available at http://{}:{}/nflow/ui/explorer/", (Object)host, (Object)port);
        logger.info("Metrics and health checks available at http://{}:{}/nflow/metrics/", (Object)host, (Object)port);
        return startedServer;
    }

    protected void setupSpring(ServletContextHandler context, ConfigurableEnvironment env) {
        NflowAnnotationConfigWebApplicationContext webContext = new NflowAnnotationConfigWebApplicationContext(env);
        if (!this.annotatedContextClasses.isEmpty()) {
            webContext.register(this.annotatedContextClasses.toArray(new Class[this.annotatedContextClasses.size()]));
        }
        context.addEventListener((EventListener)new ContextLoaderListener((WebApplicationContext)webContext));
        context.setInitParameter("contextConfigLocation", NflowJettyConfiguration.class.getName());
    }

    protected void setupCxf(ServletContextHandler context) {
        ServletHolder servlet = context.addServlet(CXFServlet.class, "/nflow/api/*");
        servlet.setDisplayName("nflow-cxf-services");
        servlet.setInitOrder(1);
    }

    protected void setupMetricsAdminServlet(ServletContextHandler context) {
        ServletHolder servlet = context.addServlet(AdminServlet.class, "/nflow/metrics/*");
        context.addEventListener((EventListener)((Object)new MetricsServletContextListener()));
        servlet.setDisplayName("nflow-metrics-admin-servlet");
        servlet.setInitOrder(2);
    }

    private Server setupServer() {
        Server server = new Server((ThreadPool)new QueuedThreadPool(100));
        server.setStopAtShutdown(true);
        return server;
    }

    private void setupJmx(Container server, Environment env) {
        if (Arrays.asList(env.getActiveProfiles()).contains("jmx")) {
            MBeanContainer mbContainer = new MBeanContainer(ManagementFactory.getPlatformMBeanServer());
            server.addEventListener((EventListener)mbContainer);
            server.addBean((Object)mbContainer);
        }
    }

    private void setupServerConnector(Server server, String host, int port) {
        ServerConnector connector = new ServerConnector(server);
        connector.setHost(host);
        connector.setPort(port);
        connector.setIdleTimeout(TimeUnit.MINUTES.toMillis(2L));
        connector.setReuseAddress(true);
        connector.setName(String.valueOf(port));
        server.addConnector((Connector)connector);
    }

    @SuppressFBWarnings(value={"WEM_WEAK_EXCEPTION_MESSAGING"}, justification="Message is ok")
    private ServletContextHandler setupServletContextHandler(String ... extraStaticResources) throws IOException {
        ServletContextHandler context = new ServletContextHandler(0);
        Resource.setDefaultUseCaches((boolean)false);
        ArrayList<String> extraResources = new ArrayList<String>();
        for (String path : extraStaticResources) {
            File f = new File(path);
            if (!f.isDirectory()) continue;
            extraResources.add(f.getCanonicalFile().toURI().toURL().toString());
        }
        for (URL url : Collections.list(this.getClass().getClassLoader().getResources("static"))) {
            extraResources.add(url.toString());
        }
        if (!extraResources.isEmpty()) {
            context.setBaseResource((Resource)new ResourceCollection(extraResources.toArray(new String[extraResources.size()])));
            logger.info("Extra static resources served from {}", extraResources);
        }
        context.setWelcomeFiles(new String[]{"index.html", "service.json"});
        ArrayList<URL> nflowUiResources = Collections.list(this.getClass().getClassLoader().getResources("nflow-ui-assets"));
        if (nflowUiResources.isEmpty()) {
            throw new RuntimeException("Could not find 'nflow-ui-assets' resource from classpath");
        }
        if (nflowUiResources.size() > 1) {
            throw new RuntimeException("Found more than one (" + nflowUiResources.size() + ") 'nflow-ui-assets' resources from classpath");
        }
        String nflowUiResourceBase = ((URL)nflowUiResources.get(0)).toString();
        logger.info("nFlow UI static resources served from {}", (Object)nflowUiResourceBase);
        ServletHolder holder = new ServletHolder((Servlet)new DefaultServlet());
        holder.setInitParameter("resourceBase", nflowUiResourceBase);
        holder.setInitParameter("pathInfoOnly", "true");
        holder.setInitParameter("dirAllowed", "false");
        holder.setInitParameter("gzip", "true");
        holder.setInitParameter("acceptRanges", "false");
        holder.setDisplayName("nflow-static");
        holder.setInitOrder(1);
        context.addServlet(holder, "/nflow/ui/*");
        MimeTypes mimeTypes = context.getMimeTypes();
        mimeTypes.addMimeMapping("ttf", "application/font-sfnt");
        mimeTypes.addMimeMapping("otf", "application/font-sfnt");
        mimeTypes.addMimeMapping("woff", "application/font-woff");
        mimeTypes.addMimeMapping("eot", "application/vnd.ms-fontobject");
        mimeTypes.addMimeMapping("svg", "image/svg+xml");
        mimeTypes.addMimeMapping("html", "text/html; charset=utf-8");
        mimeTypes.addMimeMapping("css", "text/css; charset=utf-8");
        mimeTypes.addMimeMapping("js", "application/javascript; charset=utf-8");
        return context;
    }

    private void setupHandlers(HandlerWrapper server, Handler context, PropertyResolver env) {
        HandlerCollection handlers = new HandlerCollection();
        server.setHandler((Handler)handlers);
        handlers.addHandler(context);
        handlers.addHandler((Handler)this.createAccessLogHandler(env));
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    private RequestLogHandler createAccessLogHandler(PropertyResolver env) {
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        String directory = env.getProperty("nflow.jetty.accesslog.directory", "log");
        new File(directory).mkdir();
        RequestLogWriter logWriter = new RequestLogWriter(Paths.get(directory, "yyyy_mm_dd.request.log").toString());
        String timeZoneId = TimeZone.getDefault().getID();
        logWriter.setTimeZone(timeZoneId);
        logWriter.setRetainDays(90);
        logWriter.setAppend(true);
        String logFormat = "%{client}a - %u %{yyyy-MM-dd:HH:mm:ss Z|" + timeZoneId + "}t \"%r\" %s %O \"%{Referer}i\" \"%{User-Agent}i\" %{ms}T";
        requestLogHandler.setRequestLog((RequestLog)new CustomRequestLog((RequestLog.Writer)logWriter, logFormat));
        return requestLogHandler;
    }
}

