/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.jetty.config;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.codahale.metrics.health.jvm.ThreadDeadlockHealthCheck;
import com.codahale.metrics.jvm.BufferPoolMetricSet;
import com.codahale.metrics.jvm.CachedThreadStatesGaugeSet;
import com.codahale.metrics.jvm.ClassLoadingGaugeSet;
import com.codahale.metrics.jvm.FileDescriptorRatioGauge;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadDeadlockDetector;
import jakarta.annotation.PostConstruct;
import java.lang.management.ManagementFactory;
import java.util.concurrent.TimeUnit;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MetricsConfiguration {
    @Bean
    public MetricRegistry metricRegistry() {
        return new MetricRegistry();
    }

    @Bean
    public HealthCheckRegistry healthCheckRegistry() {
        return new HealthCheckRegistry();
    }

    @PostConstruct
    public void registerHealthChecks() {
        this.healthCheckRegistry().register("threadDeadlocks", (HealthCheck)new ThreadDeadlockHealthCheck());
    }

    @PostConstruct
    public void registerMetrics() {
        MetricRegistry registry = this.metricRegistry();
        registry.register("memoryUsage", (Metric)new MemoryUsageGaugeSet());
        registry.register("bufferPools", (Metric)new BufferPoolMetricSet(ManagementFactory.getPlatformMBeanServer()));
        registry.register("garbageCollector", (Metric)new GarbageCollectorMetricSet());
        registry.register("classLoading", (Metric)new ClassLoadingGaugeSet());
        registry.register("fileDescriptorRatio", (Metric)new FileDescriptorRatioGauge());
        registry.register("threadStates", (Metric)new CachedThreadStatesGaugeSet(ManagementFactory.getThreadMXBean(), new ThreadDeadlockDetector(), 60L, TimeUnit.SECONDS));
    }
}

