/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.jetty.mapper;

import io.nflow.rest.v1.msg.ErrorResponse;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.ValidationException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import java.util.stream.Collectors;
import org.apache.cxf.validation.ResponseConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class CustomValidationExceptionMapper
implements ExceptionMapper<ValidationException> {
    private static final Logger logger = LoggerFactory.getLogger(CustomValidationExceptionMapper.class);

    public Response toResponse(ValidationException exception) {
        if (exception instanceof ConstraintViolationException && !(exception instanceof ResponseConstraintViolationException)) {
            ConstraintViolationException constraint = (ConstraintViolationException)exception;
            String error = constraint.getConstraintViolations().stream().map(violation -> {
                logger.warn("{}.{}: {}", new Object[]{violation.getRootBeanClass().getSimpleName(), violation.getPropertyPath(), violation.getMessage()});
                return violation.getPropertyPath() + ": " + violation.getMessage();
            }).collect(Collectors.joining(", "));
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorResponse(error)).build();
        }
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new ErrorResponse(exception.getMessage())).build();
    }
}

