/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.jetty.servlet;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheckRegistry;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.dropwizard.metrics.servlets.HealthCheckServlet;
import io.dropwizard.metrics.servlets.MetricsServlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class MetricsServletContextListener
implements ServletContextListener {
    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ServletContext context = servletContextEvent.getServletContext();
        MetricRegistry metricRegistry = this.getSpringBean(MetricRegistry.class, context);
        HealthCheckRegistry healthCheckRegistry = this.getSpringBean(HealthCheckRegistry.class, context);
        context.setAttribute(HealthCheckServlet.HEALTH_CHECK_REGISTRY, (Object)healthCheckRegistry);
        context.setAttribute(MetricsServlet.METRICS_REGISTRY, (Object)metricRegistry);
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="npe is unlikely")
    private <T> T getSpringBean(Class<T> clazz, ServletContext context) {
        return (T)WebApplicationContextUtils.findWebApplicationContext((ServletContext)context).getBean(clazz);
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
    }
}

