/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.metrics;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import io.nflow.engine.internal.dao.ExecutorDao;
import io.nflow.engine.listener.WorkflowExecutorListener;
import org.joda.time.DateTime;

public class MetricsWorkflowExecutorListener
implements WorkflowExecutorListener {
    private static final String EXECUTION_KEY = "nflow-metrics-execution";
    private final MetricRegistry metricRegistry;
    private final String nflowExecutorGroup;
    private final int nflowExecutorId;

    public MetricsWorkflowExecutorListener(MetricRegistry metricRegistry, ExecutorDao executors) {
        this.metricRegistry = metricRegistry;
        this.nflowExecutorGroup = executors.getExecutorGroup();
        this.nflowExecutorId = executors.getExecutorId();
    }

    public void beforeProcessing(WorkflowExecutorListener.ListenerContext context) {
        Timer.Context timerContext = this.metricRegistry.timer(this.stateMetricKey(context, "execution-time")).time();
        context.data.put(EXECUTION_KEY, timerContext);
        this.meterRetries(context);
        this.meterStartupDelay(context);
    }

    private void meterRetries(WorkflowExecutorListener.ListenerContext context) {
        this.metricRegistry.histogram(this.stateMetricKey(context, "retries")).update(context.stateExecution.getRetries());
    }

    private void meterStartupDelay(WorkflowExecutorListener.ListenerContext context) {
        if (context.instance.nextActivation != null) {
            long delay = DateTime.now().getMillis() - context.instance.nextActivation.getMillis();
            this.metricRegistry.histogram(this.groupNameMetricKey("startup-delay")).update(delay);
        }
    }

    public void afterProcessing(WorkflowExecutorListener.ListenerContext context) {
        this.stopTimer(context);
        this.metricRegistry.meter(this.stateMetricKey(context, "success-count")).mark();
    }

    private void stopTimer(WorkflowExecutorListener.ListenerContext context) {
        Timer.Context executionTimer = this.executionTimer(context);
        executionTimer.stop();
    }

    public void afterFailure(WorkflowExecutorListener.ListenerContext context, Throwable exeption) {
        this.stopTimer(context);
        this.metricRegistry.meter(this.stateMetricKey(context, "error-count")).mark();
    }

    private String stateMetricKey(WorkflowExecutorListener.ListenerContext context, String type) {
        String workflowName = context.definition.getType();
        String stateName = context.originalState;
        return String.format("%s.%s.%s.%s.%s", this.nflowExecutorGroup, this.nflowExecutorId, workflowName, stateName, type);
    }

    private String groupNameMetricKey(String type) {
        return String.format("%s.%s.%s", this.nflowExecutorGroup, this.nflowExecutorId, type);
    }

    private Timer.Context executionTimer(WorkflowExecutorListener.ListenerContext context) {
        return (Timer.Context)context.data.get(EXECUTION_KEY);
    }
}

