/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.metrics;

import com.codahale.metrics.DefaultSettableGauge;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.codahale.metrics.jmx.JmxReporter;
import io.nflow.engine.config.db.DatabaseConfiguration;
import io.nflow.engine.internal.dao.ExecutorDao;
import io.nflow.engine.service.HealthCheckService;
import io.nflow.metrics.DatabaseConnectionHealthCheck;
import io.nflow.metrics.MetricsWorkflowExecutorListener;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Named(value="nflowMetrics/metricsContext")
@Configuration
public class NflowMetricsContext {
    private static final Logger logger = LoggerFactory.getLogger(NflowMetricsContext.class);
    @Inject
    private HealthCheckService healthCheckService;
    @Inject
    private MetricRegistry metricRegistry;
    @Inject
    private HealthCheckRegistry healthCheckRegistry;
    @Inject
    private DatabaseConfiguration databaseConfiguration;

    @Bean
    public DatabaseConnectionHealthCheck databaseConnectionHealthCheck() {
        return new DatabaseConnectionHealthCheck(this.healthCheckService);
    }

    @PostConstruct
    public void registerHealthChecks() {
        this.healthCheckRegistry.register("nflowDatabaseConnection", (HealthCheck)this.databaseConnectionHealthCheck());
    }

    @PostConstruct
    public void registerDatabaseType() {
        this.metricRegistry.gauge("nflow.database.type", () -> new DefaultSettableGauge((Object)this.databaseConfiguration.getDbType()));
    }

    @Bean
    public MetricsWorkflowExecutorListener metricsWorkflowExecutorListener(ExecutorDao executors) {
        logger.info("Enabling MetricsWorkflowExecutorListener");
        return new MetricsWorkflowExecutorListener(this.metricRegistry, executors);
    }

    @Profile(value={"jmx"})
    @Bean(destroyMethod="stop")
    public JmxReporter jmxMetricsReporter() {
        logger.info("Enabling Metrics JmxReporter");
        JmxReporter jmxMetricsReporter = JmxReporter.forRegistry((MetricRegistry)this.metricRegistry).inDomain("nflow.metrics").build();
        jmxMetricsReporter.start();
        return jmxMetricsReporter;
    }
}

