/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.rest.config.jaxrs;

import io.nflow.rest.config.jaxrs.NflowCors;
import jakarta.inject.Inject;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.Provider;
import org.springframework.core.env.Environment;

@Provider
@NflowCors
public class CorsHeaderContainerResponseFilter
implements ContainerResponseFilter {
    private final boolean enabled;
    private final String origin;
    private final String headers;

    @Inject
    public CorsHeaderContainerResponseFilter(Environment env) {
        this.enabled = (Boolean)env.getRequiredProperty("nflow.rest.cors.enabled", Boolean.class);
        this.origin = env.getRequiredProperty("nflow.rest.allow.origin");
        this.headers = env.getRequiredProperty("nflow.rest.allow.headers");
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        if (this.enabled) {
            MultivaluedMap responseHeaders = responseContext.getHeaders();
            responseHeaders.add((Object)"Access-Control-Allow-Origin", (Object)this.origin);
            responseHeaders.add((Object)"Access-Control-Allow-Headers", (Object)this.headers);
            responseHeaders.add((Object)"Access-Control-Allow-Methods", (Object)"OPTIONS, GET, POST, PUT, DELETE");
            responseHeaders.add((Object)"Access-Control-Allow-Credentials", (Object)"true");
        }
    }
}

