/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.rest.v1.jaxrs;

import io.nflow.engine.internal.dao.WorkflowDefinitionDao;
import io.nflow.engine.service.WorkflowDefinitionService;
import io.nflow.rest.config.jaxrs.NflowCors;
import io.nflow.rest.v1.converter.ListWorkflowDefinitionConverter;
import io.nflow.rest.v1.jaxrs.JaxRsResource;
import io.nflow.rest.v1.msg.ListWorkflowDefinitionResponse;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Component;

@Path(value="/v1/workflow-definition")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Component
@NflowCors
@Tag(name="nFlow workflow definitions")
public class WorkflowDefinitionResource
extends JaxRsResource {
    private final WorkflowDefinitionService workflowDefinitions;
    private final ListWorkflowDefinitionConverter converter;
    private final WorkflowDefinitionDao workflowDefinitionDao;

    @Inject
    public WorkflowDefinitionResource(WorkflowDefinitionService workflowDefinitions, ListWorkflowDefinitionConverter converter, WorkflowDefinitionDao workflowDefinitionDao) {
        this.workflowDefinitions = workflowDefinitions;
        this.converter = converter;
        this.workflowDefinitionDao = workflowDefinitionDao;
    }

    @GET
    @Operation(summary="List workflow definitions", description="Returns workflow definition(s): all possible states, transitions between states and other setting metadata. The workflow definition can deployed in nFlow engine or historical workflow definition stored in the database.")
    @ApiResponse(content={@Content(array=@ArraySchema(schema=@Schema(implementation=ListWorkflowDefinitionResponse.class)))})
    public Response listWorkflowDefinitions(@QueryParam(value="type") @Parameter(description="Included workflow types") List<String> types) {
        return this.handleExceptions(() -> Response.ok((Object)super.listWorkflowDefinitions((Collection)types, this.workflowDefinitions, this.converter, this.workflowDefinitionDao)));
    }
}

