/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.rest.v1.jaxrs;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.nflow.engine.internal.dao.WorkflowInstanceDao;
import io.nflow.engine.service.WorkflowInstanceInclude;
import io.nflow.engine.service.WorkflowInstanceService;
import io.nflow.engine.workflow.instance.WorkflowInstance;
import io.nflow.engine.workflow.instance.WorkflowInstanceAction;
import io.nflow.engine.workflow.instance.WorkflowInstanceFactory;
import io.nflow.rest.config.jaxrs.NflowCors;
import io.nflow.rest.v1.ApiWorkflowInstanceInclude;
import io.nflow.rest.v1.converter.CreateWorkflowConverter;
import io.nflow.rest.v1.converter.ListWorkflowInstanceConverter;
import io.nflow.rest.v1.jaxrs.JaxRsResource;
import io.nflow.rest.v1.msg.CreateWorkflowInstanceRequest;
import io.nflow.rest.v1.msg.CreateWorkflowInstanceResponse;
import io.nflow.rest.v1.msg.ListWorkflowInstanceResponse;
import io.nflow.rest.v1.msg.SetSignalRequest;
import io.nflow.rest.v1.msg.SetSignalResponse;
import io.nflow.rest.v1.msg.UpdateWorkflowInstanceRequest;
import io.nflow.rest.v1.msg.WakeupRequest;
import io.nflow.rest.v1.msg.WakeupResponse;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.stereotype.Component;

@Path(value="/v1/workflow-instance")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Component
@NflowCors
@Tag(name="nFlow workflow instances")
public class WorkflowInstanceResource
extends JaxRsResource {
    private final WorkflowInstanceService workflowInstances;
    private final CreateWorkflowConverter createWorkflowConverter;
    private final ListWorkflowInstanceConverter listWorkflowConverter;
    private final WorkflowInstanceFactory workflowInstanceFactory;
    private final WorkflowInstanceDao workflowInstanceDao;

    @Inject
    public WorkflowInstanceResource(WorkflowInstanceService workflowInstances, CreateWorkflowConverter createWorkflowConverter, ListWorkflowInstanceConverter listWorkflowConverter, WorkflowInstanceFactory workflowInstanceFactory, WorkflowInstanceDao workflowInstanceDao) {
        this.workflowInstances = workflowInstances;
        this.createWorkflowConverter = createWorkflowConverter;
        this.listWorkflowConverter = listWorkflowConverter;
        this.workflowInstanceFactory = workflowInstanceFactory;
        this.workflowInstanceDao = workflowInstanceDao;
    }

    @OPTIONS
    @Path(value="{any: .*}")
    @Hidden
    @Consumes(value={"*/*"})
    public Response corsPreflight() {
        return Response.ok().build();
    }

    @PUT
    @Operation(summary="Submit new workflow instance")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Workflow was created", content={@Content(schema=@Schema(implementation=CreateWorkflowInstanceResponse.class))}), @ApiResponse(responseCode="400", description="If instance could not be created, for example when state variable value was too long")})
    public Response createWorkflowInstance(@Valid @RequestBody(description="Submitted workflow instance information", required=true) CreateWorkflowInstanceRequest req) {
        return this.handleExceptions(() -> {
            WorkflowInstance instance = this.createWorkflowConverter.convert(req);
            long id = this.workflowInstances.insertWorkflowInstance(instance);
            instance = this.workflowInstances.getWorkflowInstance(id, EnumSet.of(WorkflowInstanceInclude.CURRENT_STATE_VARIABLES), null);
            return Response.created((URI)URI.create(String.valueOf(id))).entity((Object)this.createWorkflowConverter.convert(instance));
        });
    }

    @PUT
    @Path(value="/id/{id}")
    @Operation(summary="Update workflow instance", description="The service is typically used in manual state transition via nFlow Explorer or a business UI.")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="If update was successful"), @ApiResponse(responseCode="400", description="If instance could not be updated, for example when state variable value was too long"), @ApiResponse(responseCode="409", description="If workflow was executing and no update was done")})
    public Response updateWorkflowInstance(@Parameter(description="Internal id for workflow instance") @PathParam(value="id") long id, @Valid @RequestBody(description="Submitted workflow instance information", required=true) UpdateWorkflowInstanceRequest req) {
        return this.handleExceptions(() -> {
            boolean updated = super.updateWorkflowInstance(id, req, this.workflowInstanceFactory, this.workflowInstances, this.workflowInstanceDao);
            return updated ? Response.noContent() : Response.status((Response.Status)Response.Status.CONFLICT);
        });
    }

    @GET
    @Path(value="/id/{id}")
    @Operation(summary="Fetch a workflow instance", description="Fetch full state and action history of a single workflow instance.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="", content={@Content(schema=@Schema(implementation=ListWorkflowInstanceResponse.class))}), @ApiResponse(responseCode="404", description="If instance could not be created, for example when state variable value was too long")})
    @SuppressFBWarnings(value={"LEST_LOST_EXCEPTION_STACK_TRACE"}, justification="The empty result exception contains no useful information")
    public Response fetchWorkflowInstance(@Parameter(description="Internal id for workflow instance") @PathParam(value="id") long id, @QueryParam(value="includes") @Parameter(description="Data to include for workflow instance.\n* currentStateVariables: current stateVariables for worfklow\n* actions: state transitions\n* actionStateVariables: state variable changes for actions\n* childWorkflows: map of created child workflow instance IDs by action ID\n") Set<ApiWorkflowInstanceInclude> includes, @QueryParam(value="include") @Parameter(description="Removed in the next major release, use `includes` instead. Data to include in workflow instance. Multiple values can be provided as comma separated string.\n* currentStateVariables: current stateVariables for worfklow\n* actions: state transitions\n* actionStateVariables: state variable changes for actions\n* childWorkflows: map of created child workflow instance IDs by action ID\n", deprecated=true) String include, @QueryParam(value="maxActions") @Parameter(description="Maximum number of actions returned for each workflow instance") Long maxActions, @QueryParam(value="queryArchive") @Parameter(description="Query also the archive if not found from main tables", schema=@Schema(defaultValue="false")) Boolean queryArchive) {
        return this.handleExceptions(() -> Response.ok((Object)super.fetchWorkflowInstance(id, includes, include, maxActions, Optional.ofNullable(queryArchive).orElse(QUERY_ARCHIVED_DEFAULT).booleanValue(), this.workflowInstances, this.listWorkflowConverter)));
    }

    @GET
    @Operation(summary="List workflow instances")
    @ApiResponse(content={@Content(array=@ArraySchema(schema=@Schema(implementation=ListWorkflowInstanceResponse.class)))})
    public Response listWorkflowInstances(@QueryParam(value="id") @Parameter(description="Internal id of workflow instance") Set<Long> ids, @QueryParam(value="type") @Parameter(description="Workflow definition type of workflow instance") Set<String> types, @QueryParam(value="parentWorkflowId") @Parameter(description="Id of parent workflow instance") Long parentWorkflowId, @QueryParam(value="parentActionId") @Parameter(description="Id of parent workflow instance action") Long parentActionId, @QueryParam(value="state") @Parameter(description="Current state of workflow instance") Set<String> states, @QueryParam(value="status") @Parameter(description="Current status of workflow instance") Set<WorkflowInstance.WorkflowInstanceStatus> statuses, @QueryParam(value="businessKey") @Parameter(description="Business key for workflow instance") String businessKey, @QueryParam(value="externalId") @Parameter(description="External id for workflow instance") String externalId, @QueryParam(value="stateVariableKey") @Parameter(description="Key of state variable that must exist for workflow instance") String stateVariableKey, @QueryParam(value="stateVariableValue") @Parameter(description="Current value of state variable defined by stateVariableKey") String stateVariableValue, @QueryParam(value="includes") @Parameter(description="Data to include for workflow instance.\n* currentStateVariables: current stateVariables for worfklow\n* actions: state transitions\n* actionStateVariables: state variable changes for actions\n* childWorkflows: map of created child workflow instance IDs by action ID\n") Set<ApiWorkflowInstanceInclude> includes, @QueryParam(value="include") @Parameter(description="Removed in the next major release, use `includes` instead. Data to include in workflow instance. Multiple values can be provided as comma separated string.\n* currentStateVariables: current stateVariables for worfklow\n* actions: state transitions\n* actionStateVariables: state variable changes for actions\n* childWorkflows: map of created child workflow instance IDs by action ID\n", deprecated=true) String include, @QueryParam(value="maxResults") @Parameter(description="Maximum number of workflow instances to be returned") Long maxResults, @QueryParam(value="maxActions") @Parameter(description="Maximum number of actions returned for each workflow instance") Long maxActions, @QueryParam(value="queryArchive") @Parameter(description="Query also the archive if not enough results found from main tables", schema=@Schema(defaultValue="false")) Boolean queryArchive) {
        return this.handleExceptions(() -> Response.ok(super.listWorkflowInstances(ids, types, parentWorkflowId, parentActionId, states, statuses, businessKey, externalId, stateVariableKey, stateVariableValue, includes, include, maxResults, maxActions, Optional.ofNullable(queryArchive).orElse(QUERY_ARCHIVED_DEFAULT).booleanValue(), this.workflowInstances, this.listWorkflowConverter).iterator()));
    }

    @PUT
    @Path(value="/{id}/signal")
    @Operation(summary="Set workflow instance signal value", description="The service may be used for example to interrupt executing workflow instance.")
    @ApiResponse(responseCode="200", description="When operation was successful", content={@Content(schema=@Schema(implementation=SetSignalResponse.class))})
    public Response setSignal(@Parameter(description="Internal id for workflow instance") @PathParam(value="id") long id, @Valid @RequestBody(description="New signal value", required=true) SetSignalRequest req) {
        return this.handleExceptions(() -> {
            SetSignalResponse response = new SetSignalResponse();
            response.setSignalSuccess = this.workflowInstances.setSignal(id, Optional.ofNullable(req.signal), req.reason, WorkflowInstanceAction.WorkflowActionType.externalChange);
            return Response.ok((Object)response);
        });
    }

    @PUT
    @Path(value="/{id}/wakeup")
    @Operation(summary="Wake up workflow instance that is waiting for next activation.", description="Sets next activation to current time. If expected states are given, only wake up if the instance is in one of the expected states.")
    @ApiResponse(responseCode="200", description="When workflow wakeup was attempted", content={@Content(schema=@Schema(implementation=WakeupResponse.class))})
    public Response wakeup(@Parameter(description="Internal id for workflow instance") @PathParam(value="id") long id, @Valid @RequestBody(description="Expected states", required=true) WakeupRequest req) {
        return this.handleExceptions(() -> {
            WakeupResponse response = new WakeupResponse();
            List expectedStates = Optional.ofNullable(req.expectedStates).orElseGet(Collections::emptyList);
            response.wakeupSuccess = this.workflowInstances.wakeupWorkflowInstance(id, expectedStates);
            return Response.ok((Object)response);
        });
    }
}

