/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.rest.config.springweb;

import io.nflow.engine.internal.executor.WorkflowInstanceExecutor;
import jakarta.inject.Inject;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

@Service
public class SchedulerService {
    private static final Logger logger = LoggerFactory.getLogger(SchedulerService.class);
    private final Scheduler scheduler;

    @Inject
    public SchedulerService(WorkflowInstanceExecutor workflowInstanceExecutor, Environment env) {
        int dbPoolSize = (Integer)env.getRequiredProperty("nflow.db.max_pool_size", Integer.class);
        int dispatcherCount = workflowInstanceExecutor.getThreadCount();
        int threadPoolSize = Math.max(dbPoolSize - dispatcherCount, 2);
        logger.info("Initializing REST API thread pool size to {}", (Object)threadPoolSize);
        this.scheduler = Schedulers.fromExecutor((Executor)Executors.newFixedThreadPool(threadPoolSize));
    }

    public <T> Mono<T> callAsync(Callable<T> callable) {
        return Mono.fromCallable(callable).subscribeOn(this.scheduler);
    }
}

