/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.rest.v1.springweb;

import io.nflow.engine.service.MaintenanceConfiguration;
import io.nflow.engine.service.MaintenanceResults;
import io.nflow.engine.service.MaintenanceService;
import io.nflow.rest.config.springweb.SchedulerService;
import io.nflow.rest.v1.converter.MaintenanceConverter;
import io.nflow.rest.v1.msg.MaintenanceRequest;
import io.nflow.rest.v1.msg.MaintenanceResponse;
import io.nflow.rest.v1.springweb.SpringWebResource;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/${nflow.rest.path.prefix}/v1/maintenance"}, produces={"application/json"})
@Component
@Tag(name="nFlow maintenance")
public class MaintenanceResource
extends SpringWebResource {
    private final MaintenanceService maintenanceService;
    private final MaintenanceConverter converter;

    @Inject
    public MaintenanceResource(SchedulerService scheduler, MaintenanceService maintenanceService, MaintenanceConverter converter) {
        super(scheduler);
        this.maintenanceService = maintenanceService;
        this.converter = converter;
    }

    @PostMapping(consumes={"application/json"})
    @Operation(description="Do maintenance on old workflow instances synchronously")
    @ApiResponse(responseCode="200", description="Maintenance operation status", content={@Content(schema=@Schema(implementation=MaintenanceResponse.class))})
    public Mono<ResponseEntity<?>> cleanupWorkflows(@RequestBody @Valid @Parameter(description="Parameters for the maintenance process", required=true) MaintenanceRequest request) {
        return this.handleExceptions(() -> this.wrapBlocking(() -> {
            MaintenanceConfiguration configuration = this.converter.convert(request);
            MaintenanceResults results = this.maintenanceService.cleanupWorkflows(configuration);
            return ResponseEntity.ok((Object)this.converter.convert(results));
        }));
    }
}

