/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.rest.v1.springweb;

import io.nflow.rest.config.springweb.SchedulerService;
import io.nflow.rest.v1.ResourceBase;
import io.nflow.rest.v1.msg.ErrorResponse;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;

public abstract class SpringWebResource
extends ResourceBase {
    private final SchedulerService scheduler;

    protected SpringWebResource(SchedulerService scheduler) {
        this.scheduler = scheduler;
    }

    protected Mono<ResponseEntity<?>> wrapBlocking(Callable<ResponseEntity<?>> callable) {
        return this.scheduler.callAsync(callable);
    }

    protected Mono<ResponseEntity<?>> handleExceptions(Supplier<Mono<ResponseEntity<?>>> response) {
        return Mono.just(response).flatMap(Supplier::get).onErrorResume(ex -> this.toErrorResponse(this.resolveExceptionHttpStatus((Throwable)ex), new ErrorResponse(ex.getMessage())));
    }

    private Mono<ResponseEntity<ErrorResponse>> toErrorResponse(int statusCode, ErrorResponse body) {
        return Mono.just((Object)ResponseEntity.status((int)statusCode).body((Object)body));
    }
}

