/*
 * Decompiled with CFR 0.152.
 */
package io.nflow.rest.v1.springweb;

import io.nflow.engine.service.WorkflowExecutorService;
import io.nflow.rest.config.springweb.SchedulerService;
import io.nflow.rest.v1.converter.ListWorkflowExecutorConverter;
import io.nflow.rest.v1.msg.ListWorkflowExecutorResponse;
import io.nflow.rest.v1.springweb.SpringWebResource;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import java.util.stream.Collectors;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/${nflow.rest.path.prefix}/v1/workflow-executor"}, produces={"application/json"})
@Component
@Tag(name="nFlow workflow executors")
public class WorkflowExecutorResource
extends SpringWebResource {
    private final WorkflowExecutorService workflowExecutors;
    private final ListWorkflowExecutorConverter converter;

    @Inject
    public WorkflowExecutorResource(SchedulerService scheduler, WorkflowExecutorService workflowExecutors, ListWorkflowExecutorConverter converter) {
        super(scheduler);
        this.workflowExecutors = workflowExecutors;
        this.converter = converter;
    }

    @GetMapping
    @Operation(summary="List workflow executors")
    @ApiResponse(content={@Content(array=@ArraySchema(schema=@Schema(implementation=ListWorkflowExecutorResponse.class)))})
    public Mono<ResponseEntity<?>> listWorkflowExecutors() {
        return this.handleExceptions(() -> this.wrapBlocking(() -> ResponseEntity.ok(this.workflowExecutors.getWorkflowExecutors().stream().map(arg_0 -> ((ListWorkflowExecutorConverter)this.converter).convert(arg_0)).collect(Collectors.toList()))));
    }
}

