/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.impl;

import com.github.kristofa.brave.Brave;
import com.github.kristofa.brave.IdConversion;
import com.github.kristofa.brave.ServerTracer;
import com.github.kristofa.brave.http.BraveHttpHeaders;
import io.opentracing.impl.AbstractSpanBuilder;
import io.opentracing.impl.BraveSpan;
import io.opentracing.impl.BraveSpanContext;
import java.util.Optional;

final class BraveSpanBuilder
extends AbstractSpanBuilder
implements BraveSpanContext {
    Long traceId = null;
    Long parentSpanId = null;
    ServerTracer serverTracer = null;
    private final Brave brave;

    static BraveSpanBuilder create(Brave brave, String operationName) {
        return new BraveSpanBuilder(brave, operationName);
    }

    private BraveSpanBuilder(Brave brave, String operationName) {
        super(operationName);
        this.brave = brave;
    }

    protected BraveSpan createSpan() {
        BraveSpanContext parent = this.getParent();
        if (null != parent) {
            this.traceId = parent.getContextTraceId();
            this.parentSpanId = parent.getContextSpanId();
            Long parentParentId = parent.getContextParentSpanId();
            this.brave.serverTracer().setStateCurrentTrace(this.traceId.longValue(), this.parentSpanId.longValue(), parentParentId, this.operationName);
        }
        if (null == this.traceId && null == this.parentSpanId) {
            this.brave.serverTracer().clearCurrentSpan();
        }
        BraveSpan span = BraveSpan.create(this.brave, this.operationName, Optional.ofNullable(parent), this.start, Optional.ofNullable(this.serverTracer));
        this.brave.serverTracer().setStateCurrentTrace(span.spanId.traceId, span.spanId.spanId, Long.valueOf(span.spanId.parentId), span.getOperationName());
        assert (null == this.traceId && null == this.parentSpanId || null != this.traceId && null != this.parentSpanId);
        assert (null == this.traceId || span.spanId.traceId == this.traceId);
        assert (null == this.parentSpanId || this.parentSpanId.equals(span.spanId.nullableParentId()));
        if (null == this.traceId && null == this.parentSpanId) {
            this.brave.serverTracer().setStateCurrentTrace(span.spanId.traceId, span.spanId.spanId, span.spanId.nullableParentId(), this.operationName);
        }
        return span;
    }

    BraveSpanBuilder withServerTracer(ServerTracer serverTracer) {
        this.serverTracer = serverTracer;
        return this;
    }

    private BraveSpanContext getParent() {
        for (AbstractSpanBuilder.Reference reference : this.references) {
            if (!"child_of".equals(reference.getReferenceType())) continue;
            return (BraveSpanContext)reference.getReferredTo();
        }
        return null;
    }

    boolean isTraceState(String key, Object value) {
        return null != BraveSpanBuilder.valueOf(key);
    }

    private static BraveHttpHeaders valueOf(String key) {
        for (BraveHttpHeaders header : BraveHttpHeaders.values()) {
            if (!header.getName().equals(key)) continue;
            return header;
        }
        return null;
    }

    BraveSpanBuilder withStateItem(String key, Object value) {
        BraveHttpHeaders header = BraveSpanBuilder.valueOf(key);
        if (null == header) {
            throw new IllegalArgumentException(key + " is not a valid brave header");
        }
        switch (header) {
            case TraceId: {
                this.traceId = value instanceof Number ? ((Number)value).longValue() : IdConversion.convertToLong((String)value.toString());
                break;
            }
            case SpanId: {
                this.parentSpanId = value instanceof Number ? ((Number)value).longValue() : IdConversion.convertToLong((String)value.toString());
                break;
            }
            case ParentSpanId: {
                if (null != this.parentSpanId) break;
                this.parentSpanId = value instanceof Number ? ((Number)value).longValue() : IdConversion.convertToLong((String)value.toString());
            }
        }
        return this;
    }

    @Override
    public long getContextTraceId() {
        return this.traceId;
    }

    @Override
    public long getContextSpanId() {
        return this.parentSpanId;
    }

    @Override
    public Long getContextParentSpanId() {
        return null;
    }
}

