/*
 * Decompiled with CFR 0.152.
 */
package brave.opentracing;

import brave.Span;
import brave.Tracer;
import brave.opentracing.BraveSpan;
import brave.opentracing.BraveSpanContext;
import brave.propagation.SamplingFlags;
import brave.propagation.TraceContext;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.tag.Tags;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public final class BraveSpanBuilder
implements Tracer.SpanBuilder {
    private final Tracer braveTracer;
    private final Map<String, String> tags = new LinkedHashMap<String, String>();
    private String operationName;
    private long timestamp;
    private TraceContext parent;

    BraveSpanBuilder(Tracer braveTracer, String operationName) {
        this.braveTracer = braveTracer;
        this.operationName = operationName;
    }

    public Tracer.SpanBuilder asChildOf(SpanContext parent) {
        return this.addReference("child_of", parent);
    }

    public Tracer.SpanBuilder asChildOf(io.opentracing.Span parent) {
        return this.asChildOf(parent.context());
    }

    public Tracer.SpanBuilder addReference(String type, SpanContext context) {
        if (this.parent != null) {
            return this;
        }
        if ("child_of".equals(type) || "follows_from".equals(type)) {
            this.parent = ((BraveSpanContext)context).unwrap();
        }
        return this;
    }

    public Tracer.SpanBuilder withTag(String key, String value) {
        this.tags.put(key, value);
        return this;
    }

    public Tracer.SpanBuilder withTag(String key, boolean value) {
        return this.withTag(key, Boolean.toString(value));
    }

    public Tracer.SpanBuilder withTag(String key, Number value) {
        return this.withTag(key, value.toString());
    }

    public Tracer.SpanBuilder withStartTimestamp(long microseconds) {
        this.timestamp = microseconds;
        return this;
    }

    public BraveSpan start() {
        Span span;
        boolean server = "server".equals(this.tags.get(Tags.SPAN_KIND.getKey()));
        if (this.parent == null) {
            Object samplingFlags = SamplingFlags.EMPTY;
            String string = this.tags.get(Tags.SAMPLING_PRIORITY.getKey());
            if (string != null) {
                try {
                    Integer samplingPriority = Integer.valueOf(string);
                    if (samplingPriority == 0) {
                        samplingFlags = SamplingFlags.NOT_SAMPLED;
                    } else if (samplingPriority > 0) {
                        samplingFlags = SamplingFlags.SAMPLED;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            span = this.braveTracer.newTrace((SamplingFlags)samplingFlags);
        } else {
            span = server ? this.braveTracer.joinSpan(this.parent) : this.braveTracer.newChild(this.parent);
        }
        if (this.operationName != null) {
            span.name(this.operationName);
        }
        for (Map.Entry entry : this.tags.entrySet()) {
            span.tag((String)entry.getKey(), (String)entry.getValue());
            if (Tags.SPAN_KIND.getKey().equals(entry.getKey()) && "client".equals(entry.getValue())) {
                span.kind(Span.Kind.CLIENT);
                continue;
            }
            if (!server) continue;
            span.kind(Span.Kind.SERVER);
        }
        Span result = this.timestamp != 0L ? span.start(this.timestamp) : span.start();
        return BraveSpan.wrap(result);
    }

    public Iterable<Map.Entry<String, String>> baggageItems() {
        return Collections.EMPTY_SET;
    }
}

