/*
 * Decompiled with CFR 0.152.
 */
package brave.opentracing;

import brave.Tracer;
import brave.Tracing;
import brave.opentracing.BraveSpanBuilder;
import brave.opentracing.BraveSpanContext;
import brave.opentracing.BraveTracer$$Lambda$1;
import brave.opentracing.BraveTracer$TextMapExtractorAdaptor$$Lambda$1;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public final class BraveTracer
implements io.opentracing.Tracer {
    final Tracer brave4;
    final Map<Format<TextMap>, TraceContext.Injector<TextMap>> formatToInjector = new LinkedHashMap<Format<TextMap>, TraceContext.Injector<TextMap>>();
    final Map<Format<TextMap>, TraceContext.Extractor<TextMap>> formatToExtractor = new LinkedHashMap<Format<TextMap>, TraceContext.Extractor<TextMap>>();

    public static BraveTracer create(Tracing brave4) {
        return BraveTracer.newBuilder(brave4).build();
    }

    public static Builder newBuilder(Tracing brave4) {
        return new Builder(brave4);
    }

    BraveTracer(Builder b) {
        this.brave4 = b.brave4.tracer();
        for (Map.Entry<Format<TextMap>, Propagation<String>> entry : b.formatToPropagation.entrySet()) {
            this.formatToInjector.put(entry.getKey(), (TraceContext.Injector<TextMap>)entry.getValue().injector(BraveTracer$$Lambda$1.lambdaFactory$()));
            this.formatToExtractor.put(entry.getKey(), new TextMapExtractorAdaptor(entry.getValue()));
        }
    }

    public Tracer.SpanBuilder buildSpan(String operationName) {
        return new BraveSpanBuilder(this.brave4, operationName);
    }

    public <C> void inject(SpanContext spanContext, Format<C> format, C carrier) {
        TraceContext.Injector<TextMap> injector = this.formatToInjector.get(format);
        if (injector == null) {
            throw new UnsupportedOperationException(format + " not in " + this.formatToInjector.keySet());
        }
        TraceContext traceContext = ((BraveSpanContext)spanContext).unwrap();
        injector.inject(traceContext, (Object)((TextMap)carrier));
    }

    public <C> SpanContext extract(Format<C> format, C carrier) {
        TraceContext.Extractor<TextMap> extractor = this.formatToExtractor.get(format);
        if (extractor == null) {
            throw new UnsupportedOperationException(format + " not in " + this.formatToExtractor.keySet());
        }
        TraceContextOrSamplingFlags result = extractor.extract((Object)((TextMap)carrier));
        TraceContext context = result.context() != null ? result.context() : this.brave4.newTrace(result.samplingFlags()).context();
        return BraveSpanContext.wrap(context);
    }

    static Set<String> lowercaseSet(List<String> fields) {
        LinkedHashSet<String> lcSet = new LinkedHashSet<String>();
        for (String f : fields) {
            lcSet.add(f.toLowerCase());
        }
        return lcSet;
    }

    static final class TextMapExtractorAdaptor
    implements TraceContext.Extractor<TextMap> {
        final Set<String> fields;
        final TraceContext.Extractor<Map<String, String>> delegate;

        TextMapExtractorAdaptor(Propagation<String> propagation) {
            this.fields = BraveTracer.lowercaseSet(propagation.keys());
            this.delegate = propagation.extractor(BraveTracer$TextMapExtractorAdaptor$$Lambda$1.lambdaFactory$());
        }

        public TraceContextOrSamplingFlags extract(TextMap entries) {
            LinkedHashMap cache = new LinkedHashMap();
            for (Map.Entry next : entries) {
                String inputKey = ((String)next.getKey()).toLowerCase(Locale.ROOT);
                if (!this.fields.contains(inputKey)) continue;
                cache.put(inputKey, next.getValue());
            }
            return this.delegate.extract(cache);
        }

        static /* synthetic */ String lambda$new$0(Map m, String k) {
            return (String)m.get(k.toLowerCase(Locale.ROOT));
        }
    }

    public static final class Builder {
        Tracing brave4;
        Map<Format<TextMap>, Propagation<String>> formatToPropagation = new LinkedHashMap<Format<TextMap>, Propagation<String>>();

        Builder(Tracing brave4) {
            if (brave4 == null) {
                throw new NullPointerException("brave tracing component == null");
            }
            this.brave4 = brave4;
            this.formatToPropagation.put((Format<TextMap>)Format.Builtin.HTTP_HEADERS, (Propagation<String>)brave4.propagation());
            this.formatToPropagation.put((Format<TextMap>)Format.Builtin.TEXT_MAP, (Propagation<String>)brave4.propagation());
        }

        public Builder textMapPropagation(Format<TextMap> format, Propagation<String> propagation) {
            if (format == null) {
                throw new NullPointerException("format == null");
            }
            if (propagation == null) {
                throw new NullPointerException("propagation == null");
            }
            this.formatToPropagation.put(format, propagation);
            return this;
        }

        public BraveTracer build() {
            return new BraveTracer(this);
        }
    }
}

