/*
 * Decompiled with CFR 0.152.
 */
package brave.opentracing;

import brave.Tracer;
import brave.opentracing.BraveActiveSpanSource;
import brave.opentracing.BraveBaseSpan;
import brave.opentracing.BraveSpan;
import io.opentracing.ActiveSpan;
import java.util.concurrent.atomic.AtomicInteger;

public final class BraveActiveSpan
extends BraveBaseSpan<ActiveSpan>
implements ActiveSpan {
    private final BraveActiveSpanSource source;
    private final Tracer.SpanInScope scope;
    private final BraveSpan wrapped;
    private final AtomicInteger refCount;

    BraveActiveSpan(BraveActiveSpanSource source, Tracer.SpanInScope scope, BraveSpan wrapped) {
        super(wrapped.unwrap());
        this.source = source;
        this.scope = scope;
        this.wrapped = wrapped;
        this.refCount = new AtomicInteger(1);
    }

    private BraveActiveSpan(BraveActiveSpanSource source, Tracer.SpanInScope scope, BraveSpan wrapped, AtomicInteger refCount) {
        super(wrapped.unwrap());
        this.source = source;
        this.scope = scope;
        this.wrapped = wrapped;
        this.refCount = refCount;
    }

    public void deactivate() {
        if (0 == this.refCount.decrementAndGet()) {
            this.wrapped.finish();
            this.scope.close();
            this.source.deregisterSpan(this.wrapped.unwrap());
        }
    }

    public Continuation capture() {
        return new Continuation();
    }

    public void close() {
        this.deactivate();
    }

    public String toString() {
        return "BraveActiveSpan{scope=" + this.scope + ", wrapped=" + this.wrapped + ", refCount=" + this.refCount + '}';
    }

    public final class Continuation
    implements ActiveSpan.Continuation {
        Continuation() {
            BraveActiveSpan.this.refCount.incrementAndGet();
        }

        public ActiveSpan activate() {
            return new BraveActiveSpan(BraveActiveSpan.this.source, BraveActiveSpan.this.scope, BraveActiveSpan.this.wrapped, BraveActiveSpan.this.refCount);
        }
    }
}

