/*
 * Decompiled with CFR 0.152.
 */
package brave.opentracing;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.opentracing.BraveActiveSpan;
import brave.opentracing.BraveSpan;
import io.opentracing.ActiveSpan;
import io.opentracing.ActiveSpanSource;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

final class BraveActiveSpanSource
implements ActiveSpanSource {
    private final Map<Long, BraveActiveSpan> activeSpans = new ConcurrentHashMap<Long, BraveActiveSpan>();
    private final Tracer tracer;

    BraveActiveSpanSource(Tracing brave4) {
        this.tracer = brave4.tracer();
    }

    public ActiveSpan activeSpan() {
        Span span = this.tracer.currentSpan();
        if (span == null) {
            return null;
        }
        return this.getOrEstablishActiveSpan(span);
    }

    public BraveActiveSpan makeActive(io.opentracing.Span span) {
        if (span == null) {
            return null;
        }
        if (!(span instanceof BraveSpan)) {
            throw new IllegalArgumentException("Span must be an instance of brave.opentracing.BraveSpan, but was " + span.getClass());
        }
        BraveSpan wrappedSpan = (BraveSpan)span;
        Span rawSpan = wrappedSpan.unwrap();
        return this.getOrEstablishActiveSpan(rawSpan);
    }

    private BraveActiveSpan getOrEstablishActiveSpan(Span span) {
        long spanId = span.context().spanId();
        BraveActiveSpan braveActiveSpan = this.activeSpans.get(spanId);
        if (braveActiveSpan == null) {
            braveActiveSpan = new BraveActiveSpan(this, this.tracer.withSpanInScope(span), BraveSpan.wrap(span));
            this.activeSpans.put(spanId, braveActiveSpan);
        }
        return braveActiveSpan;
    }

    void deregisterSpan(Span span) {
        this.activeSpans.remove(span.context().spanId());
    }
}

