/*
 * Decompiled with CFR 0.152.
 */
package brave.opentracing;

import brave.Span;
import brave.opentracing.BraveSpanContext;
import io.opentracing.BaseSpan;
import io.opentracing.SpanContext;
import io.opentracing.tag.Tags;
import java.util.Iterator;
import java.util.Map;

abstract class BraveBaseSpan<T extends BaseSpan<T>>
implements BaseSpan<T> {
    protected final Span delegate;
    protected final SpanContext context;

    BraveBaseSpan(Span delegate) {
        if (delegate == null) {
            throw new NullPointerException("wrapped span == null");
        }
        this.delegate = delegate;
        this.context = BraveSpanContext.wrap(delegate.context());
    }

    public final Span unwrap() {
        return this.delegate;
    }

    public SpanContext context() {
        return this.context;
    }

    public void finish() {
        this.delegate.finish();
    }

    public void finish(long finishMicros) {
        this.delegate.finish(finishMicros);
    }

    public T setTag(String key, String value) {
        this.delegate.tag(key, value);
        if (Tags.SPAN_KIND.getKey().equals(key) && "client".equals(value)) {
            this.delegate.kind(Span.Kind.CLIENT);
        } else if (Tags.SPAN_KIND.getKey().equals(key) && "server".equals(value)) {
            this.delegate.kind(Span.Kind.SERVER);
        }
        return (T)this;
    }

    public T setTag(String key, boolean value) {
        return this.setTag(key, Boolean.toString(value));
    }

    public T setTag(String key, Number value) {
        return this.setTag(key, value.toString());
    }

    public T log(Map<String, ?> fields) {
        if (fields.isEmpty()) {
            return (T)this;
        }
        return this.log(BraveBaseSpan.toAnnotation(fields));
    }

    public T log(long timestampMicroseconds, Map<String, ?> fields) {
        if (fields.isEmpty()) {
            return (T)this;
        }
        return this.log(timestampMicroseconds, BraveBaseSpan.toAnnotation(fields));
    }

    static String toAnnotation(Map<String, ?> fields) {
        Object event = fields.get("event");
        if (event != null && fields.size() == 1) {
            return event.toString();
        }
        return BraveBaseSpan.joinOnEqualsSpace(fields);
    }

    static String joinOnEqualsSpace(Map<String, ?> fields) {
        if (fields.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        Iterator<Map.Entry<String, ?>> i = fields.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, ?> next = i.next();
            result.append(next.getKey()).append('=').append(next.getValue());
            if (!i.hasNext()) continue;
            result.append(' ');
        }
        return result.toString();
    }

    public T log(String event) {
        this.delegate.annotate(event);
        return (T)this;
    }

    public T log(long timestampMicroseconds, String event) {
        this.delegate.annotate(timestampMicroseconds, event);
        return (T)this;
    }

    public T log(String eventName, Object ignored) {
        return this.log(eventName);
    }

    public T log(long timestampMicroseconds, String eventName, Object ignored) {
        return this.log(timestampMicroseconds, eventName);
    }

    public T setBaggageItem(String key, String value) {
        return (T)this;
    }

    public String getBaggageItem(String key) {
        return null;
    }

    public T setOperationName(String operationName) {
        this.delegate.name(operationName);
        return (T)this;
    }
}

