/*
 * Decompiled with CFR 0.152.
 */
package brave.opentracing;

import brave.Span;
import brave.Tracer;
import brave.opentracing.BraveSpan;
import brave.opentracing.BraveSpanContext;
import brave.propagation.SamplingFlags;
import brave.propagation.TraceContext;
import io.opentracing.Scope;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.tag.Tags;
import java.util.LinkedHashMap;
import java.util.Map;
import zipkin2.Endpoint;

public final class BraveSpanBuilder
implements Tracer.SpanBuilder {
    private final io.opentracing.Tracer tracer;
    private final Tracer braveTracer;
    private final Map<String, String> tags = new LinkedHashMap<String, String>();
    private final Endpoint.Builder remoteEndpoint = Endpoint.newBuilder();
    private String operationName;
    private long timestamp;
    private TraceContext parent;
    private boolean ignoreActiveSpan = false;

    BraveSpanBuilder(io.opentracing.Tracer tracer, Tracer braveTracer, String operationName) {
        this.tracer = tracer;
        this.braveTracer = braveTracer;
        this.operationName = operationName;
    }

    public BraveSpanBuilder asChildOf(SpanContext parent) {
        return this.addReference("child_of", parent);
    }

    public BraveSpanBuilder asChildOf(io.opentracing.Span parent) {
        return this.asChildOf(parent != null ? parent.context() : null);
    }

    public BraveSpanBuilder addReference(String type, SpanContext context) {
        if (this.parent != null || context == null) {
            return this;
        }
        if ("child_of".equals(type) || "follows_from".equals(type)) {
            this.parent = ((BraveSpanContext)context).unwrap();
        }
        return this;
    }

    public BraveSpanBuilder withTag(String key, String value) {
        if (BraveSpan.trySetPeer(this.remoteEndpoint, key, value)) {
            return this;
        }
        this.tags.put(key, value);
        return this;
    }

    public BraveSpanBuilder withTag(String key, boolean value) {
        if (Tags.ERROR.getKey().equals(key) && !value) {
            return this;
        }
        return this.withTag(key, Boolean.toString(value));
    }

    public BraveSpanBuilder withTag(String key, Number value) {
        if (BraveSpan.trySetPeer(this.remoteEndpoint, key, value)) {
            return this;
        }
        return this.withTag(key, value.toString());
    }

    public BraveSpanBuilder withStartTimestamp(long microseconds) {
        this.timestamp = microseconds;
        return this;
    }

    @Deprecated
    public BraveSpan startManual() {
        return this.start();
    }

    public Scope startActive(boolean finishSpanOnClose) {
        Scope parent;
        if (!this.ignoreActiveSpan && (parent = this.tracer.scopeManager().active()) != null) {
            this.asChildOf(parent.span());
        }
        return this.tracer.scopeManager().activate((io.opentracing.Span)this.start(), finishSpanOnClose);
    }

    public BraveSpanBuilder ignoreActiveSpan() {
        this.ignoreActiveSpan = true;
        return this;
    }

    public BraveSpan start() {
        Span span;
        Scope parent;
        boolean server = "server".equals(this.tags.get(Tags.SPAN_KIND.getKey()));
        if (this.parent == null && !this.ignoreActiveSpan && (parent = this.tracer.scopeManager().active()) != null) {
            this.asChildOf(parent.span());
        }
        if (this.parent == null) {
            SamplingFlags samplingFlags = SamplingFlags.EMPTY;
            String sampling = this.tags.get(Tags.SAMPLING_PRIORITY.getKey());
            if (sampling != null) {
                try {
                    Integer samplingPriority = Integer.valueOf(sampling);
                    if (samplingPriority == 0) {
                        samplingFlags = SamplingFlags.NOT_SAMPLED;
                    } else if (samplingPriority > 0) {
                        samplingFlags = SamplingFlags.SAMPLED;
                    }
                }
                catch (NumberFormatException samplingPriority) {
                    // empty catch block
                }
            }
            span = this.braveTracer.newTrace(samplingFlags);
        } else {
            span = server && this.parent.shared() ? this.braveTracer.joinSpan(this.parent) : this.braveTracer.newChild(this.parent);
        }
        if (this.operationName != null) {
            span.name(this.operationName);
        }
        for (Map.Entry<String, String> tag : this.tags.entrySet()) {
            String value;
            String key = tag.getKey();
            if (BraveSpan.trySetKind(span, key, value = tag.getValue())) continue;
            span.tag(key, value);
        }
        if (this.timestamp != 0L) {
            span.start(this.timestamp);
        } else {
            span.start();
        }
        return new BraveSpan(span, this.remoteEndpoint.build());
    }
}

