/*
 * Decompiled with CFR 0.152.
 */
package brave.opentracing;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.opentracing.BraveScope;
import brave.opentracing.BraveSpan;
import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

final class BraveScopeManager
implements ScopeManager {
    private final Map<Long, BraveScope> activeSpans = new ConcurrentHashMap<Long, BraveScope>();
    private final Tracer tracer;

    BraveScopeManager(Tracing brave4) {
        this.tracer = brave4.tracer();
    }

    public Scope active() {
        Span span = this.tracer.currentSpan();
        if (span == null) {
            return null;
        }
        return this.getOrEstablishActiveSpan(span, false);
    }

    public BraveScope activate(io.opentracing.Span span, boolean finishSpanOnClose) {
        if (span == null) {
            return null;
        }
        if (!(span instanceof BraveSpan)) {
            throw new IllegalArgumentException("Span must be an instance of brave.opentracing.BraveSpan, but was " + span.getClass());
        }
        BraveSpan wrappedSpan = (BraveSpan)span;
        Span rawSpan = wrappedSpan.unwrap();
        return this.getOrEstablishActiveSpan(rawSpan, finishSpanOnClose);
    }

    private BraveScope getOrEstablishActiveSpan(Span span, boolean finishSpanOnClose) {
        long spanId = span.context().spanId();
        BraveScope braveScope = this.activeSpans.get(spanId);
        if (braveScope == null) {
            braveScope = new BraveScope(this, this.tracer.withSpanInScope(span), new BraveSpan(span, BraveSpan.EMPTY_ENDPOINT), finishSpanOnClose);
            this.activeSpans.put(spanId, braveScope);
        }
        return braveScope;
    }

    void deregisterSpan(Span span) {
        this.activeSpans.remove(span.context().spanId());
    }
}

