/*
 * Decompiled with CFR 0.152.
 */
package brave.opentracing;

import brave.Span;
import brave.opentracing.AbandonedSpan;
import brave.opentracing.BraveSpanContext;
import brave.propagation.ExtraFieldPropagation;
import brave.propagation.TraceContext;
import io.opentracing.tag.Tags;
import java.util.Iterator;
import java.util.Map;
import zipkin2.Endpoint;

public final class BraveSpan
implements io.opentracing.Span {
    static final Endpoint EMPTY_ENDPOINT = Endpoint.newBuilder().build();
    volatile Span delegate;
    private final Endpoint.Builder remoteEndpointBuilder;

    BraveSpan(Span delegate, Endpoint remoteEndpoint) {
        if (delegate == null) {
            throw new NullPointerException("delegate == null");
        }
        this.delegate = delegate;
        this.remoteEndpointBuilder = remoteEndpoint.toBuilder();
    }

    public final Span unwrap() {
        return this.delegate;
    }

    public BraveSpanContext context() {
        return BraveSpanContext.create(this.delegate.context());
    }

    public BraveSpan setTag(String key, String value) {
        if (BraveSpan.trySetPeer(this.remoteEndpointBuilder, key, value)) {
            return this;
        }
        if (BraveSpan.trySetKind(this.delegate, key, value)) {
            return this;
        }
        this.delegate.tag(key, value);
        return this;
    }

    public BraveSpan setTag(String key, boolean value) {
        if (Tags.ERROR.getKey().equals(key) && !value) {
            return this;
        }
        return this.setTag(key, Boolean.toString(value));
    }

    public BraveSpan setTag(String key, Number value) {
        if (BraveSpan.trySetPeer(this.remoteEndpointBuilder, key, value)) {
            return this;
        }
        if (Tags.SAMPLING_PRIORITY.getKey().equals(key) && value.intValue() == 0) {
            this.delegate.abandon();
            this.delegate = new AbandonedSpan(this.delegate.context().toBuilder().sampled(false).build());
        }
        return this.setTag(key, value.toString());
    }

    public BraveSpan log(Map<String, ?> fields) {
        if (fields.isEmpty()) {
            return this;
        }
        return this.log(BraveSpan.toAnnotation(fields));
    }

    public BraveSpan log(long timestampMicroseconds, Map<String, ?> fields) {
        if (fields.isEmpty()) {
            return this;
        }
        return this.log(timestampMicroseconds, BraveSpan.toAnnotation(fields));
    }

    public BraveSpan log(String event) {
        this.delegate.annotate(event);
        return this;
    }

    public BraveSpan log(long timestampMicroseconds, String event) {
        this.delegate.annotate(timestampMicroseconds, event);
        return this;
    }

    public BraveSpan setBaggageItem(String key, String value) {
        ExtraFieldPropagation.set((TraceContext)this.delegate.context(), (String)key, (String)value);
        return this;
    }

    public String getBaggageItem(String key) {
        return ExtraFieldPropagation.get((TraceContext)this.delegate.context(), (String)key);
    }

    public BraveSpan setOperationName(String operationName) {
        this.delegate.name(operationName);
        return this;
    }

    public void finish() {
        this.trySetRemoteEndpoint();
        this.delegate.finish();
    }

    public void finish(long finishMicros) {
        this.trySetRemoteEndpoint();
        this.delegate.finish(finishMicros);
    }

    static String toAnnotation(Map<String, ?> fields) {
        Object event = fields.get("event");
        if (event != null && fields.size() == 1) {
            return event.toString();
        }
        return BraveSpan.joinOnEqualsSpace(fields);
    }

    static String joinOnEqualsSpace(Map<String, ?> fields) {
        if (fields.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        Iterator<Map.Entry<String, ?>> i = fields.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, ?> next = i.next();
            result.append(next.getKey()).append('=').append(next.getValue());
            if (!i.hasNext()) continue;
            result.append(' ');
        }
        return result.toString();
    }

    void trySetRemoteEndpoint() {
        Endpoint remoteEndpoint = this.remoteEndpointBuilder.build();
        if (!remoteEndpoint.equals((Object)EMPTY_ENDPOINT)) {
            this.delegate.remoteEndpoint(remoteEndpoint);
        }
    }

    static boolean trySetKind(Span span, String key, String value) {
        if (!Tags.SPAN_KIND.getKey().equals(key)) {
            return false;
        }
        if ("client".equals(value)) {
            span.kind(Span.Kind.CLIENT);
        } else if ("server".equals(value)) {
            span.kind(Span.Kind.SERVER);
        } else if ("client".equals(value)) {
            span.kind(Span.Kind.CLIENT);
        } else if ("producer".equals(value)) {
            span.kind(Span.Kind.PRODUCER);
        } else if ("consumer".equals(value)) {
            span.kind(Span.Kind.CONSUMER);
        } else {
            return false;
        }
        return true;
    }

    static boolean trySetPeer(Endpoint.Builder remoteEndpoint, String key, String value) {
        if (Tags.PEER_SERVICE.getKey().equals(key)) {
            remoteEndpoint.serviceName(value);
        } else if (Tags.PEER_HOST_IPV4.getKey().equals(key) || Tags.PEER_HOST_IPV6.getKey().equals(key)) {
            remoteEndpoint.ip(value);
        } else {
            return false;
        }
        return true;
    }

    static boolean trySetPeer(Endpoint.Builder remoteEndpoint, String key, Number value) {
        if (Tags.PEER_HOST_IPV4.getKey().equals(key)) {
            int ipv4 = value.intValue();
            remoteEndpoint.ip("" + (ipv4 >> 24 & 0xFF) + '.' + (ipv4 >> 16 & 0xFF) + '.' + (ipv4 >> 8 & 0xFF) + '.' + (ipv4 & 0xFF));
        } else if (Tags.PEER_PORT.getKey().equals(key)) {
            remoteEndpoint.port(Integer.valueOf(value.intValue()));
        } else {
            return false;
        }
        return true;
    }
}

